package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the TERMINAL table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="TERMINAL"
 */

public abstract class BaseTerminal  implements Comparable, Serializable {

	public static String REF = "Terminal"; //$NON-NLS-1$
	public static String PROP_IS_AUTO_LOG_OFF_ENABLED = "isAutoLogOffEnabled"; //$NON-NLS-1$
	public static String PROP_OPENING_BALANCE = "openingBalance"; //$NON-NLS-1$
	public static String PROP_ASSIGNED_USER_ID = "assignedUserId"; //$NON-NLS-1$
	public static String PROP_SHOW_PRNT_BTN = "showPrntBtn"; //$NON-NLS-1$
	public static String PROP_FIXED_SALES_AREA = "fixedSalesArea"; //$NON-NLS-1$
	public static String PROP_CURRENT_BALANCE = "currentBalance"; //$NON-NLS-1$
	public static String PROP_KIOSK_MODE = "kioskMode"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_GROUP_BY_CATAGORY_KIT_RECEIPT = "groupByCatagoryKitReceipt"; //$NON-NLS-1$
	public static String PROP_SMTP_SENDER = "smtpSender"; //$NON-NLS-1$
	public static String PROP_TERMINAL_TYPE_ID = "terminalTypeId"; //$NON-NLS-1$
	public static String PROP_INVENTORY_OUT_LOCATION_ID = "inventoryOutLocationId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_EXTRA_PROPERTIES = "extraProperties"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_SMTP_PORT = "smtpPort"; //$NON-NLS-1$
	public static String PROP_INVENTORY_IN_LOCATION_ID = "inventoryInLocationId"; //$NON-NLS-1$
	public static String PROP_SHOW_DB_CONFIG = "showDbConfig"; //$NON-NLS-1$
	public static String PROP_SMTP_PASSWORD = "smtpPassword"; //$NON-NLS-1$
	public static String PROP_DEFAULT_PASS_LENGTH = "defaultPassLength"; //$NON-NLS-1$
	public static String PROP_HAS_CASH_DRAWER = "hasCashDrawer"; //$NON-NLS-1$
	public static String PROP_SALES_AREA_ID = "salesAreaId"; //$NON-NLS-1$
	public static String PROP_FLOOR_ID = "floorId"; //$NON-NLS-1$
	public static String PROP_AUTO_LOG_OFF_SEC = "autoLogOffSec"; //$NON-NLS-1$
	public static String PROP_TERMINAL_KEY = "terminalKey"; //$NON-NLS-1$
	public static String PROP_CURRENT_CASH_DRAWER = "currentCashDrawer"; //$NON-NLS-1$
	public static String PROP_MASTER_TERMINAL = "masterTerminal"; //$NON-NLS-1$
	public static String PROP_DEVICE_TYPE = "deviceType"; //$NON-NLS-1$
	public static String PROP_ACTIVE = "active"; //$NON-NLS-1$
	public static String PROP_SHOW_BARCODE_ON_RECEIPT = "showBarcodeOnReceipt"; //$NON-NLS-1$
	public static String PROP_ENABLE_MULTI_CURRENCY = "enableMultiCurrency"; //$NON-NLS-1$
	public static String PROP_SMTP_HOST = "smtpHost"; //$NON-NLS-1$
	public static String PROP_DEPARTMENT_ID = "departmentId"; //$NON-NLS-1$
	public static String PROP_CONFIRM_TICKET_SETTLEMENT = "confirmTicketSettlement"; //$NON-NLS-1$
	public static String PROP_SHOW_TRANSLATED_NAME = "showTranslatedName"; //$NON-NLS-1$
	public static String PROP_LOCATION = "location"; //$NON-NLS-1$


	// constructors
	public BaseTerminal () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseTerminal (
		java.lang.Integer id,
		java.lang.String outletId) {

		this.setId(id);
		this.setOutletId(outletId);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key

	private java.lang.Integer id;

	private java.lang.String outletId;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.String terminalKey;
				private java.lang.Integer deviceType;
				private java.lang.Double openingBalance;
				private java.lang.Double currentBalance;
				private java.lang.Boolean hasCashDrawer;
				private java.lang.String location;
				private java.lang.String assignedUserId;
				private java.lang.String departmentId;
				private java.lang.String salesAreaId;
				private java.lang.String terminalTypeId;
				private java.lang.String inventoryInLocationId;
				private java.lang.String inventoryOutLocationId;
				private java.lang.Boolean confirmTicketSettlement;
				private java.lang.Boolean showDbConfig;
				private java.lang.Boolean isAutoLogOffEnabled;
				private java.lang.Boolean showTranslatedName;
				private java.lang.Boolean showBarcodeOnReceipt;
				private java.lang.Boolean groupByCatagoryKitReceipt;
				private java.lang.Boolean enableMultiCurrency;
				private java.lang.Integer floorId;
				private java.lang.Integer autoLogOffSec;
				private java.lang.Integer defaultPassLength;
				private java.lang.String smtpHost;
				private java.lang.Integer smtpPort;
				private java.lang.String smtpSender;
				private java.lang.String smtpPassword;
				private java.lang.Boolean kioskMode;
				private java.lang.Boolean active;
				private java.lang.Boolean showPrntBtn;
				private java.lang.Boolean fixedSalesArea;
				private java.lang.Boolean masterTerminal;
				private java.lang.String extraProperties;
				private java.lang.Boolean deleted;
	
	// many to one
	private com.floreantpos.model.CashDrawer currentCashDrawer;

	// collections
	private java.util.Map<String,String> properties;



	/**
     * @hibernate.property
     *  column=ID
	 * not-null=true
	 */
	public java.lang.Integer getId () {
		return this.id;
	}

	/**
	 * Set the value related to the column: ID
	 * @param id the ID value
	 */
	public void setId (java.lang.Integer id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
     * @hibernate.property
     *  column=OUTLET_ID
	 * not-null=true
	 */
	public java.lang.String getOutletId () {
		return this.outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: TERMINAL_KEY
	 */

	public java.lang.String getTerminalKey () {
			return terminalKey;
	}



	/**
	 * Set the value related to the column: TERMINAL_KEY
	 * @param terminalKey the TERMINAL_KEY value
	 */
			public void setTerminalKey (java.lang.String terminalKey) {
			this.terminalKey = terminalKey;
	}



	/**
	 * Return the value associated with the column: DEVICE_TYPE
	 */

	public java.lang.Integer getDeviceType () {
						return deviceType == null ? Integer.valueOf(0) : deviceType;
		}



	/**
	 * Set the value related to the column: DEVICE_TYPE
	 * @param deviceType the DEVICE_TYPE value
	 */
			public void setDeviceType (java.lang.Integer deviceType) {
			this.deviceType = deviceType;
	}



	/**
	 * Return the value associated with the column: OPENING_BALANCE
	 */

	public java.lang.Double getOpeningBalance () {
						return openingBalance == null ? Double.valueOf(0) : openingBalance;
		}



	/**
	 * Set the value related to the column: OPENING_BALANCE
	 * @param openingBalance the OPENING_BALANCE value
	 */
			public void setOpeningBalance (java.lang.Double openingBalance) {
			this.openingBalance = openingBalance;
	}



	/**
	 * Return the value associated with the column: CURRENT_BALANCE
	 */

	public java.lang.Double getCurrentBalance () {
						return currentBalance == null ? Double.valueOf(0) : currentBalance;
		}



	/**
	 * Set the value related to the column: CURRENT_BALANCE
	 * @param currentBalance the CURRENT_BALANCE value
	 */
			public void setCurrentBalance (java.lang.Double currentBalance) {
			this.currentBalance = currentBalance;
	}



	/**
	 * Return the value associated with the column: HAS_CASH_DRAWER
	 */

	public java.lang.Boolean isHasCashDrawer () {
						return hasCashDrawer == null ? Boolean.valueOf(true) : hasCashDrawer;
			}

	public java.lang.Boolean getHasCashDrawer () {
					return hasCashDrawer == null ? Boolean.valueOf(true) : hasCashDrawer;
			}


	/**
	 * Set the value related to the column: HAS_CASH_DRAWER
	 * @param hasCashDrawer the HAS_CASH_DRAWER value
	 */
			public void setHasCashDrawer (java.lang.Boolean hasCashDrawer) {
			this.hasCashDrawer = hasCashDrawer;
	}


	/**
	 * Custom property
	 */
	public static String getHasCashDrawerDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: LOCATION
	 */

	public java.lang.String getLocation () {
			return location;
	}



	/**
	 * Set the value related to the column: LOCATION
	 * @param location the LOCATION value
	 */
			public void setLocation (java.lang.String location) {
			this.location = location;
	}



	/**
	 * Return the value associated with the column: ASSIGNED_USER
	 */

	public java.lang.String getAssignedUserId () {
			return assignedUserId;
	}



	/**
	 * Set the value related to the column: ASSIGNED_USER
	 * @param assignedUserId the ASSIGNED_USER value
	 */
			public void setAssignedUserId (java.lang.String assignedUserId) {
			this.assignedUserId = assignedUserId;
	}



	/**
	 * Return the value associated with the column: DEPT_ID
	 */

	public java.lang.String getDepartmentId () {
			return departmentId;
	}



	/**
	 * Set the value related to the column: DEPT_ID
	 * @param departmentId the DEPT_ID value
	 */
			public void setDepartmentId (java.lang.String departmentId) {
			this.departmentId = departmentId;
	}



	/**
	 * Return the value associated with the column: SALES_AREA_ID
	 */

	public java.lang.String getSalesAreaId () {
			return salesAreaId;
	}



	/**
	 * Set the value related to the column: SALES_AREA_ID
	 * @param salesAreaId the SALES_AREA_ID value
	 */
			public void setSalesAreaId (java.lang.String salesAreaId) {
			this.salesAreaId = salesAreaId;
	}



	/**
	 * Return the value associated with the column: TERMINAL_TYPE_ID
	 */

	public java.lang.String getTerminalTypeId () {
			return terminalTypeId;
	}



	/**
	 * Set the value related to the column: TERMINAL_TYPE_ID
	 * @param terminalTypeId the TERMINAL_TYPE_ID value
	 */
			public void setTerminalTypeId (java.lang.String terminalTypeId) {
			this.terminalTypeId = terminalTypeId;
	}



	/**
	 * Return the value associated with the column: IN_LOCATION_ID
	 */

	public java.lang.String getInventoryInLocationId () {
			return inventoryInLocationId;
	}



	/**
	 * Set the value related to the column: IN_LOCATION_ID
	 * @param inventoryInLocationId the IN_LOCATION_ID value
	 */
			public void setInventoryInLocationId (java.lang.String inventoryInLocationId) {
			this.inventoryInLocationId = inventoryInLocationId;
	}



	/**
	 * Return the value associated with the column: OUT_LOCATION_ID
	 */

	public java.lang.String getInventoryOutLocationId () {
			return inventoryOutLocationId;
	}



	/**
	 * Set the value related to the column: OUT_LOCATION_ID
	 * @param inventoryOutLocationId the OUT_LOCATION_ID value
	 */
			public void setInventoryOutLocationId (java.lang.String inventoryOutLocationId) {
			this.inventoryOutLocationId = inventoryOutLocationId;
	}



	/**
	 * Return the value associated with the column: CONFIRM_TICKET_SETTLEMENT
	 */

	public java.lang.Boolean isConfirmTicketSettlement () {
					return confirmTicketSettlement == null ? Boolean.FALSE : confirmTicketSettlement;
		}

	public java.lang.Boolean getConfirmTicketSettlement () {
				return confirmTicketSettlement == null ? Boolean.FALSE : confirmTicketSettlement;
			}


	/**
	 * Set the value related to the column: CONFIRM_TICKET_SETTLEMENT
	 * @param confirmTicketSettlement the CONFIRM_TICKET_SETTLEMENT value
	 */
			public void setConfirmTicketSettlement (java.lang.Boolean confirmTicketSettlement) {
			this.confirmTicketSettlement = confirmTicketSettlement;
	}



	/**
	 * Return the value associated with the column: SHOW_DB_CONFIG
	 */

	public java.lang.Boolean isShowDbConfig () {
						return showDbConfig == null ? Boolean.valueOf(true) : showDbConfig;
			}

	public java.lang.Boolean getShowDbConfig () {
					return showDbConfig == null ? Boolean.valueOf(true) : showDbConfig;
			}


	/**
	 * Set the value related to the column: SHOW_DB_CONFIG
	 * @param showDbConfig the SHOW_DB_CONFIG value
	 */
			public void setShowDbConfig (java.lang.Boolean showDbConfig) {
			this.showDbConfig = showDbConfig;
	}


	/**
	 * Custom property
	 */
	public static String getShowDbConfigDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: AUTO_LOGG_OFF
	 */

	public java.lang.Boolean isIsAutoLogOffEnabled () {
					return isAutoLogOffEnabled == null ? Boolean.FALSE : isAutoLogOffEnabled;
		}

	public java.lang.Boolean getIsAutoLogOffEnabled () {
				return isAutoLogOffEnabled == null ? Boolean.FALSE : isAutoLogOffEnabled;
			}


	/**
	 * Set the value related to the column: AUTO_LOGG_OFF
	 * @param isAutoLogOffEnabled the AUTO_LOGG_OFF value
	 */
			public void setIsAutoLogOffEnabled (java.lang.Boolean isAutoLogOffEnabled) {
			this.isAutoLogOffEnabled = isAutoLogOffEnabled;
	}



	/**
	 * Return the value associated with the column: SHOW_TRANSLATED_NAME
	 */

	public java.lang.Boolean isShowTranslatedName () {
					return showTranslatedName == null ? Boolean.FALSE : showTranslatedName;
		}

	public java.lang.Boolean getShowTranslatedName () {
				return showTranslatedName == null ? Boolean.FALSE : showTranslatedName;
			}


	/**
	 * Set the value related to the column: SHOW_TRANSLATED_NAME
	 * @param showTranslatedName the SHOW_TRANSLATED_NAME value
	 */
			public void setShowTranslatedName (java.lang.Boolean showTranslatedName) {
			this.showTranslatedName = showTranslatedName;
	}



	/**
	 * Return the value associated with the column: SHOW_BARCODE_ON_RECEIPT
	 */

	public java.lang.Boolean isShowBarcodeOnReceipt () {
					return showBarcodeOnReceipt == null ? Boolean.FALSE : showBarcodeOnReceipt;
		}

	public java.lang.Boolean getShowBarcodeOnReceipt () {
				return showBarcodeOnReceipt == null ? Boolean.FALSE : showBarcodeOnReceipt;
			}


	/**
	 * Set the value related to the column: SHOW_BARCODE_ON_RECEIPT
	 * @param showBarcodeOnReceipt the SHOW_BARCODE_ON_RECEIPT value
	 */
			public void setShowBarcodeOnReceipt (java.lang.Boolean showBarcodeOnReceipt) {
			this.showBarcodeOnReceipt = showBarcodeOnReceipt;
	}



	/**
	 * Return the value associated with the column: GROUP_BY_CATEGORY_IN_KITCHEN_RECEIPT
	 */

	public java.lang.Boolean isGroupByCatagoryKitReceipt () {
					return groupByCatagoryKitReceipt == null ? Boolean.FALSE : groupByCatagoryKitReceipt;
		}

	public java.lang.Boolean getGroupByCatagoryKitReceipt () {
				return groupByCatagoryKitReceipt == null ? Boolean.FALSE : groupByCatagoryKitReceipt;
			}


	/**
	 * Set the value related to the column: GROUP_BY_CATEGORY_IN_KITCHEN_RECEIPT
	 * @param groupByCatagoryKitReceipt the GROUP_BY_CATEGORY_IN_KITCHEN_RECEIPT value
	 */
			public void setGroupByCatagoryKitReceipt (java.lang.Boolean groupByCatagoryKitReceipt) {
			this.groupByCatagoryKitReceipt = groupByCatagoryKitReceipt;
	}



	/**
	 * Return the value associated with the column: ENABLE_MULTI_CURRENCY
	 */

	public java.lang.Boolean isEnableMultiCurrency () {
					return enableMultiCurrency == null ? Boolean.FALSE : enableMultiCurrency;
		}

	public java.lang.Boolean getEnableMultiCurrency () {
				return enableMultiCurrency == null ? Boolean.FALSE : enableMultiCurrency;
			}


	/**
	 * Set the value related to the column: ENABLE_MULTI_CURRENCY
	 * @param enableMultiCurrency the ENABLE_MULTI_CURRENCY value
	 */
			public void setEnableMultiCurrency (java.lang.Boolean enableMultiCurrency) {
			this.enableMultiCurrency = enableMultiCurrency;
	}



	/**
	 * Return the value associated with the column: FLOOR_ID
	 */

	public java.lang.Integer getFloorId () {
						return floorId == null ? Integer.valueOf(0) : floorId;
		}



	/**
	 * Set the value related to the column: FLOOR_ID
	 * @param floorId the FLOOR_ID value
	 */
			public void setFloorId (java.lang.Integer floorId) {
			this.floorId = floorId;
	}



	/**
	 * Return the value associated with the column: AUTO_LOGG_OFF_SEC
	 */

	public java.lang.Integer getAutoLogOffSec () {
						return autoLogOffSec == null ? Integer.valueOf(0) : autoLogOffSec;
		}



	/**
	 * Set the value related to the column: AUTO_LOGG_OFF_SEC
	 * @param autoLogOffSec the AUTO_LOGG_OFF_SEC value
	 */
			public void setAutoLogOffSec (java.lang.Integer autoLogOffSec) {
			this.autoLogOffSec = autoLogOffSec;
	}



	/**
	 * Return the value associated with the column: DEFAULT_PASS_LENGTH
	 */

	public java.lang.Integer getDefaultPassLength () {
						return defaultPassLength == null ? Integer.valueOf(0) : defaultPassLength;
		}



	/**
	 * Set the value related to the column: DEFAULT_PASS_LENGTH
	 * @param defaultPassLength the DEFAULT_PASS_LENGTH value
	 */
			public void setDefaultPassLength (java.lang.Integer defaultPassLength) {
			this.defaultPassLength = defaultPassLength;
	}



	/**
	 * Return the value associated with the column: SMTP_HOST
	 */

	public java.lang.String getSmtpHost () {
			return smtpHost;
	}



	/**
	 * Set the value related to the column: SMTP_HOST
	 * @param smtpHost the SMTP_HOST value
	 */
			public void setSmtpHost (java.lang.String smtpHost) {
			this.smtpHost = smtpHost;
	}



	/**
	 * Return the value associated with the column: SMTP_PORT
	 */

	public java.lang.Integer getSmtpPort () {
						return smtpPort == null ? Integer.valueOf(0) : smtpPort;
		}



	/**
	 * Set the value related to the column: SMTP_PORT
	 * @param smtpPort the SMTP_PORT value
	 */
			public void setSmtpPort (java.lang.Integer smtpPort) {
			this.smtpPort = smtpPort;
	}



	/**
	 * Return the value associated with the column: SMTP_SENDER
	 */

	public java.lang.String getSmtpSender () {
			return smtpSender;
	}



	/**
	 * Set the value related to the column: SMTP_SENDER
	 * @param smtpSender the SMTP_SENDER value
	 */
			public void setSmtpSender (java.lang.String smtpSender) {
			this.smtpSender = smtpSender;
	}



	/**
	 * Return the value associated with the column: SMTP_PASSWORD
	 */

	public java.lang.String getSmtpPassword () {
			return smtpPassword;
	}



	/**
	 * Set the value related to the column: SMTP_PASSWORD
	 * @param smtpPassword the SMTP_PASSWORD value
	 */
			public void setSmtpPassword (java.lang.String smtpPassword) {
			this.smtpPassword = smtpPassword;
	}



	/**
	 * Return the value associated with the column: KIOSK_MODE
	 */

	public java.lang.Boolean isKioskMode () {
					return kioskMode == null ? Boolean.FALSE : kioskMode;
		}

	public java.lang.Boolean getKioskMode () {
				return kioskMode == null ? Boolean.FALSE : kioskMode;
			}


	/**
	 * Set the value related to the column: KIOSK_MODE
	 * @param kioskMode the KIOSK_MODE value
	 */
			public void setKioskMode (java.lang.Boolean kioskMode) {
			this.kioskMode = kioskMode;
	}



	/**
	 * Return the value associated with the column: ACTIVE
	 */

	public java.lang.Boolean isActive () {
						return active == null ? Boolean.valueOf(true) : active;
			}

	public java.lang.Boolean getActive () {
					return active == null ? Boolean.valueOf(true) : active;
			}


	/**
	 * Set the value related to the column: ACTIVE
	 * @param active the ACTIVE value
	 */
			public void setActive (java.lang.Boolean active) {
			this.active = active;
	}


	/**
	 * Custom property
	 */
	public static String getActiveDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: SHOW_PRINT_BTN
	 */

	public java.lang.Boolean isShowPrntBtn () {
						return showPrntBtn == null ? Boolean.valueOf(true) : showPrntBtn;
			}

	public java.lang.Boolean getShowPrntBtn () {
					return showPrntBtn == null ? Boolean.valueOf(true) : showPrntBtn;
			}


	/**
	 * Set the value related to the column: SHOW_PRINT_BTN
	 * @param showPrntBtn the SHOW_PRINT_BTN value
	 */
			public void setShowPrntBtn (java.lang.Boolean showPrntBtn) {
			this.showPrntBtn = showPrntBtn;
	}


	/**
	 * Custom property
	 */
	public static String getShowPrntBtnDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: FIXED_SALES_AREA
	 */

	public java.lang.Boolean isFixedSalesArea () {
					return fixedSalesArea == null ? Boolean.FALSE : fixedSalesArea;
		}

	public java.lang.Boolean getFixedSalesArea () {
				return fixedSalesArea == null ? Boolean.FALSE : fixedSalesArea;
			}


	/**
	 * Set the value related to the column: FIXED_SALES_AREA
	 * @param fixedSalesArea the FIXED_SALES_AREA value
	 */
			public void setFixedSalesArea (java.lang.Boolean fixedSalesArea) {
			this.fixedSalesArea = fixedSalesArea;
	}



	/**
	 * Return the value associated with the column: MASTER_TERMINAL
	 */

	public java.lang.Boolean isMasterTerminal () {
					return masterTerminal == null ? Boolean.FALSE : masterTerminal;
		}

	public java.lang.Boolean getMasterTerminal () {
				return masterTerminal == null ? Boolean.FALSE : masterTerminal;
			}


	/**
	 * Set the value related to the column: MASTER_TERMINAL
	 * @param masterTerminal the MASTER_TERMINAL value
	 */
			public void setMasterTerminal (java.lang.Boolean masterTerminal) {
			this.masterTerminal = masterTerminal;
	}



	/**
	 * Return the value associated with the column: EXTRA_PROPERTIES
	 */

	public java.lang.String getExtraProperties () {
			return extraProperties;
	}



	/**
	 * Set the value related to the column: EXTRA_PROPERTIES
	 * @param extraProperties the EXTRA_PROPERTIES value
	 */
			public void setExtraProperties (java.lang.String extraProperties) {
			this.extraProperties = extraProperties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: CURRENT_CASH_DRAWER_ID
	 */

	public com.floreantpos.model.CashDrawer getCurrentCashDrawer () {
			return currentCashDrawer;
	}



	/**
	 * Set the value related to the column: CURRENT_CASH_DRAWER_ID
	 * @param currentCashDrawer the CURRENT_CASH_DRAWER_ID value
	 */
			public void setCurrentCashDrawer (com.floreantpos.model.CashDrawer currentCashDrawer) {
			this.currentCashDrawer = currentCashDrawer;
	}



	/**
	 * Return the value associated with the column: properties
	 */

	public java.util.Map<String,String> getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: properties
	 * @param properties the properties value
	 */
			public void setProperties (java.util.Map<String,String> properties) {
			this.properties = properties;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;//abcd
		if (!(obj instanceof com.floreantpos.model.Terminal)) return false;
		else {
			com.floreantpos.model.Terminal terminal = (com.floreantpos.model.Terminal) obj;
			if (null != this.getId() && null != terminal.getId()) {
				if (!this.getId().equals(terminal.getId())) {
					return false;
				}
			}
			else {
				return false;
			}
			if (null != this.getOutletId() && null != terminal.getOutletId()) {
				if (!this.getOutletId().equals(terminal.getOutletId())) {
					return false;
				}
			}
			else {
				return false;
			}
			return true;
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			StringBuilder sb = new StringBuilder();
			if (null != this.getId()) {
				sb.append(this.getId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			if (null != this.getOutletId()) {
				sb.append(this.getOutletId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			this.hashCode = sb.toString().hashCode();
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}