package com.floreantpos.model.dao;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.Notification;

public class NotificationDAO extends BaseNotificationDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public NotificationDAO() {
	}

	@SuppressWarnings("unchecked")
	public List<Notification> getUnreadNotifications(String subscriptionId, String invoiceId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Notification.class);
			addDeletedFilter(criteria);
			if (StringUtils.isNotBlank(subscriptionId)) {
				criteria.add(Restrictions.eq(Notification.PROP_SUBSCRIPTION_ID, subscriptionId));
			}
			if (StringUtils.isNotBlank(invoiceId)) {
				criteria.add(Restrictions.eq(Notification.PROP_INVOICE_ID, invoiceId));
			}
			criteria.add(Restrictions.eq(Notification.PROP_UNREAD, Boolean.TRUE));
			criteria.addOrder(Order.desc(Notification.PROP_CREATED_DATE));
			return criteria.list();
		}
	}

	@SuppressWarnings("unchecked")
	public List<Notification> getUnreadNotifications() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Notification.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(Notification.PROP_UNREAD, Boolean.TRUE));
			criteria.addOrder(Order.desc(Notification.PROP_CREATED_DATE));
			return criteria.list();
		}
	}

	public void clearNotifications(String subscriptionId) {
		List<Notification> notifications = getUnreadNotifications(subscriptionId, null);
		if (notifications == null || notifications.isEmpty()) {
			return;
		}
		try (Session session = createNewSession()) {
			Transaction tx = session.beginTransaction();
			for (Notification notification : notifications) {
				notification.setUnread(false);
				notification.setDeleted(true);
				saveOrUpdate(notification, session);
			}
			tx.commit();
		}
	}

}