package com.floreantpos.model.util.pricecalc;

import java.lang.reflect.Method;

import com.floreantpos.model.TicketItem;

public class TicketItemCalcFactory {
	private static TicketItemCalc ticketItemCalcV1;
	private static TicketItemCalc ticketItemCalcV2;
	
	public static TicketItemCalc getCalc(TicketItem ticketItem) {
		try {
			if (ticketItem == null || ticketItem.getDataVersion() >= 2) {
				if (ticketItemCalcV2 != null) {
					return ticketItemCalcV2;
				}
				
				Class<?> clazz = Class.forName("com.orocube.pos.pricecalc.TicketItemPriceCalcV2"); //$NON-NLS-1$
				Method method = clazz.getMethod("getInstance"); //$NON-NLS-1$
				ticketItemCalcV2 = (TicketItemCalc) method.invoke(null);
				
				return ticketItemCalcV2;
			}
			else {
				if (ticketItemCalcV1 != null) {
					return ticketItemCalcV1;
				}
				
				Class<?> clazz = Class.forName("com.orocube.pos.pricecalc.TicketItemPriceCalcV1"); //$NON-NLS-1$
				Method method = clazz.getMethod("getInstance"); //$NON-NLS-1$
				ticketItemCalcV1 = (TicketItemCalc) method.invoke(null);
				return ticketItemCalcV1;
			} 
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
