package com.floreantpos.report;

import java.io.Serializable;
import java.io.StringReader;
import java.util.Date;
import java.util.Iterator;

import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.PosLog;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.JsonUtil;

public class DiscountData implements Serializable {

	private String itemName;
	private String ticketId;
	private Date date;
	private double totalWithDiscount;
	private double totalItemDiscount;
	private String properties;

	private boolean isTicketDiscount = Boolean.FALSE;

	public String getItemName() {
		return itemName;
	}

	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public String getTicketId() {
		return ticketId;
	}

	public void setTicketId(String ticketId) {
		this.ticketId = ticketId;
	}

	public String getFormattedDate() {
		if (date == null) {
			return null;
		}
		return DateUtil.formatDateAsString(date);
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public double getDiscount() {
		if (isTicketDiscount) {
			return getTicketDiscount();
		}
		return getTotalItemDiscount();
	}

	public double getTotalWithDiscount() {
		return totalWithDiscount;
	}

	public void setTotalWithDiscount(double totalWithDiscount) {
		this.totalWithDiscount = totalWithDiscount;
	}

	public String getProperties() {
		return properties;
	}

	public void setProperties(String properties) {
		this.properties = properties;
	}

	public double getTicketDiscount() {
		if (StringUtils.isBlank(properties) || properties.equals("[]")) { //$NON-NLS-1$
			return 0.0;
		}
		double discountAmount = 0.0;
		try (JsonReader jsonParser = Json.createReader(new StringReader(properties))) {
			JsonArray jsonArray = jsonParser.readArray();
			for (Iterator<?> iterator = jsonArray.iterator(); iterator.hasNext();) {
				JsonObject dObj = (JsonObject) iterator.next();
				discountAmount += JsonUtil.getDouble(dObj, TicketDiscount.PROP_TOTAL_DISCOUNT_AMOUNT);
			}
		} catch (Exception e) {
			PosLog.error(DiscountData.class, e);
		}
		return discountAmount;
	}

	public double getItemDiscount() {
		if (StringUtils.isBlank(properties) || properties.equals("[]")) { //$NON-NLS-1$
			return 0.0;
		}
		double discountAmount = 0.0;
		try (JsonReader jsonParser = Json.createReader(new StringReader(properties))) {
			JsonArray jsonArray = jsonParser.readArray();
			for (Iterator<?> iterator = jsonArray.iterator(); iterator.hasNext();) {
				JsonObject dObj = (JsonObject) iterator.next();
				discountAmount += JsonUtil.getDouble(dObj, TicketItemDiscount.PROP_AMOUNT);
			}
		} catch (Exception e) {
			PosLog.error(DiscountData.class, e);
		}
		return discountAmount;
	}

	public String getDiscountName() {
		if (StringUtils.isBlank(properties) || properties.equals("[]")) { //$NON-NLS-1$
			return null;
		}
		String discountName = ""; //$NON-NLS-1$
		try (JsonReader jsonParser = Json.createReader(new StringReader(properties))) {
			JsonArray jsonArray = jsonParser.readArray();
			for (Iterator<?> iterator = jsonArray.iterator(); iterator.hasNext();) {
				JsonObject dObj = (JsonObject) iterator.next();

				discountName += JsonUtil.getString(dObj, TicketDiscount.PROP_NAME);
				if (iterator.hasNext()) {
					discountName += ", "; //$NON-NLS-1$
				}
			}
		} catch (Exception e) {
			PosLog.error(DiscountData.class, e);
		}
		return discountName;
	}

	public boolean isTicketDiscount() {
		return isTicketDiscount;
	}

	public void setTicketDiscount(boolean isTicketDiscount) {
		this.isTicketDiscount = isTicketDiscount;
	}

	public double getTotalItemDiscount() {
		return totalItemDiscount;
	}

	public void setTotalItemDiscount(double totalItemDiscount) {
		this.totalItemDiscount = totalItemDiscount;
	}

}
