/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.Date;

import com.floreantpos.model.User;

public class WeeklyPayrollReportData {
	private User user;
	private long totalWorkHourMs, regularWorkHourMs, overtimeMs;
	private double regularWorkHour, overtimeHour;
	private double regularPayment, overtimePayment, totalPayment;
	private Date fromDateOfWeek, toDateOfWeek;
	private double totalDeclaredTips, totalNoCashTips;
	private int firstDayOfWeek;
	private String regularHourDisplay, overtimeDisplay, totalHourDisplay;
	private String userIdSortKey;

	public void calculate() {
		totalPayment = regularPayment + overtimePayment;
		totalHourDisplay = getHour(totalWorkHourMs) + "h " + getMin(totalWorkHourMs) + "m"; //$NON-NLS-1$ //$NON-NLS-2$
		regularHourDisplay = getHour(regularWorkHourMs) + "h " + getMin(regularWorkHourMs) + "m"; //$NON-NLS-1$ //$NON-NLS-2$
		overtimeDisplay = getHour(overtimeMs) + "h " + getMin(overtimeMs) + "m"; //$NON-NLS-1$ //$NON-NLS-2$
	}

	private long getHour(long valueInMS) {
		return valueInMS / (60 * 60 * 1000);
	}

	private long getMin(long valueInMS) {
		long hour = valueInMS / (60 * 60 * 1000);
		valueInMS = valueInMS - hour * (60 * 60 * 1000);
		return valueInMS / (60 * 1000);
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public double getRegularHour() {
		return regularWorkHour;
	}

	public void setRegularHour(double totalHour) {
		this.regularWorkHour = totalHour;
	}

	public double getTotalPayment() {
		return totalPayment;
	}

	public void setTotalPayment(double payment) {
		this.totalPayment = payment;
	}

	public Date getFromDateOfWeek() {
		return fromDateOfWeek;
	}

	public void setFromDateOfWeek(Date fromDateOfWeek) {
		this.fromDateOfWeek = fromDateOfWeek;
	}

	public Date getToDateOfWeek() {
		return toDateOfWeek;
	}

	public void setToDateOfWeek(Date toDateOfWeek) {
		this.toDateOfWeek = toDateOfWeek;
	}

	public double getOvertime() {
		return overtimeHour;
	}

	public void setOvertime(double overtime) {
		this.overtimeHour = overtime;
	}

	public double getRegularPayment() {
		return regularPayment;
	}

	public void setRegularPayment(double regularPayment) {
		this.regularPayment = regularPayment;
	}

	public double getOvertimePayment() {
		return overtimePayment;
	}

	public void setOvertimePayment(double overtimePayment) {
		this.overtimePayment = overtimePayment;
	}

	public double getTotalDeclaredTips() {
		return totalDeclaredTips;
	}

	public void setTotalDeclaredTips(double totalDeclaredTips) {
		this.totalDeclaredTips = totalDeclaredTips;
	}

	public double getTotalNoCashTips() {
		return totalNoCashTips;
	}

	public void setTotalNoCashTips(double totalNoCashTips) {
		this.totalNoCashTips = totalNoCashTips;
	}

	public int getFirstDayOfWeek() {
		return firstDayOfWeek;
	}

	public void setFirstDayOfWeek(int firstDayOfWeek) {
		this.firstDayOfWeek = firstDayOfWeek;
	}

	public long getTotalWorkHourMs() {
		return totalWorkHourMs;
	}

	public void setTotalWorkHourMs(long totalWorkHourMs) {
		this.totalWorkHourMs = totalWorkHourMs;
	}

	public String getRegularHourDisplay() {
		return regularHourDisplay;
	}

	public void setRegularHourDisplay(String regularHourDisplay) {
		this.regularHourDisplay = regularHourDisplay;
	}

	public String getOvertimeDisplay() {
		return overtimeDisplay;
	}

	public void setOvertimeDisplay(String overtimeDisplay) {
		this.overtimeDisplay = overtimeDisplay;
	}

	public String getTotalHourDisplay() {
		return totalHourDisplay;
	}

	public void setTotalHourDisplay(String totalHourDisplay) {
		this.totalHourDisplay = totalHourDisplay;
	}

	public String getUserIdSortKey() {
		return userIdSortKey;
	}

	public void setUserIdSortKey(String userIdSortKey) {
		this.userIdSortKey = userIdSortKey;
	}

	public long getRegularWorkHourMs() {
		return regularWorkHourMs;
	}

	public void setRegularWorkHourMs(long regularWorkHourMs) {
		this.regularWorkHourMs = regularWorkHourMs;
	}

	public long getOvertimeMs() {
		return overtimeMs;
	}

	public void setOvertimeMs(long overtimeMS) {
		this.overtimeMs = overtimeMS;
	}
}
