package com.floreantpos.report.model;

import java.util.List;

import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.ListTableModel;

public class InvTransactionsReportModel extends ListTableModel {

	public InvTransactionsReportModel() {
		super(new String[] { "name", "type", "fromLocation", "toLocation", "transTime", "unitPrice", "unitCost", "qty", "unit", "batch", "total", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$//$NON-NLS-8$//$NON-NLS-9$//$NON-NLS-10$//$NON-NLS-11$
				"inventoryType" }); //$NON-NLS-1$

	}

	public void setItems(List<InventoryTransaction> transactions) {
		setRows(transactions);
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		InventoryTransaction transactionData = (InventoryTransaction) rows.get(rowIndex);

		MenuItem menuItem = transactionData.getMenuItem();
		switch (columnIndex) {
			case 0:
				return menuItem.getDisplayName();

			case 1:
				return transactionData.getTransactionType().name();

			case 2:
				return transactionData.getFromInventoryLocationDisplayString();

			case 3:
				return transactionData.getToInventoryLocationDisplayString();

			case 4:
				return transactionData.getTransactionDateAsString();

			case 5:
				return transactionData.getUnitPrice();

			case 6:
				return transactionData.getUnitCost();

			case 7:
				return transactionData.getQuantity();

			case 8:
				return transactionData.getUnitName();

			case 9:
				//return transactionData.getBatchNumber();
				return "";

			case 10:
				return transactionData.getTotal();

			case 11:
				return transactionData.getReason();

		}
		return null;
	}

}