/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

import com.floreantpos.model.Currency;
import com.floreantpos.model.util.DataProvider;

public class CurrencyUtil {

	public static Currency getMainCurrency() {
		return DataProvider.get().getMainCurrency();
	}

	public static List<Currency> getAllCurrency(String outletId) {
		return DataProvider.get().getCurrencies(outletId);
	}

	public static String getCurrencyName() {
		return getMainCurrency().getName();
	}

	public static String getCurrencySymbol() {
		Currency mainCurrency = getMainCurrency();
		if (mainCurrency == null) {
			return "";
		}
		return mainCurrency.getSymbol();
	}

	public static String getCurrencySymbolWithBracket() {
		return " (" + getCurrencySymbol() + ")"; //$NON-NLS-1$ //$NON-NLS-2$
	}

	public static List<Currency> getAllPreFillCurrencies() {
		Set<com.ibm.icu.util.Currency> currencies = com.ibm.icu.util.Currency.getAvailableCurrencies();
		List<Currency> currencyList = new ArrayList<Currency>();

		for (com.ibm.icu.util.Currency ibmCurrency : currencies) {
			Currency currency = new Currency();
			currency.setName(ibmCurrency.getDisplayName());
			currency.setCode(ibmCurrency.getCurrencyCode());
			String symbol = ibmCurrency.getSymbol();
			currency.setSymbol(symbol);
			currencyList.add(currency);
		}

		Collections.sort(currencyList, new Comparator<Currency>() {
			@Override
			public int compare(Currency o1, Currency o2) {
				return o1.getName().compareTo(o2.getName());
			}
		});

		return currencyList;
	}
}
