package com.floreantpos.model;

import com.floreantpos.model.base.BaseAgent;

public class Agent extends BaseAgent {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Agent() {
	}

	/**
	 * Constructor for primary key
	 */
	public Agent(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	/**
	 * @param commissionValue can be fixed amount or % amount
	 * 
	 */
	public void putAgentCommissionOnReport(String commissionValue) {
		addProperty("agent.report.commission_value", commissionValue); //$NON-NLS-1$
	}

	public String getAgentCommissionOnReport() {
		return getProperty("agent.report.commission_value", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * @param commissionValue can be fixed amount or % amount
	 * 
	 */
	public void putAgentCommissionOnNetSales(String commissionValue) {
		addProperty("agent.netsales.commission_value", commissionValue); //$NON-NLS-1$
	}

	public String getAgentCommissionOnNetSales() {
		return getProperty("agent.netsales.commission_value", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	public void putAgentSalary(double salary) {
		addProperty("agent.salary", String.valueOf(salary)); //$NON-NLS-1$
	}

	public double getAgentSalary() {
		return PropertyContainer.parseDouble(getProperty("agent.salary", "")); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	public void putAgentType(String agentTypeName) {
		addProperty("agent.type", agentTypeName); //$NON-NLS-1$
	}

	public String getAgentType() {
		return getProperty("agent.type", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}
}