package com.floreantpos.model;

import com.floreantpos.model.base.BaseDoctor;

public class Doctor extends BaseDoctor {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Doctor() {
	}

	/**
	 * Constructor for primary key
	 */
	public Doctor(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void putDoctorAgentId(String agentId) {
		addProperty("doctor.agent.id", agentId); //$NON-NLS-1$
	}

	public String getDoctorAgentId() {
		return getProperty("doctor.agent.id", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putDoctorCommissionPercentage(String commissionPercentage) {
		addProperty("doctor.commission_percentage", commissionPercentage); //$NON-NLS-1$
	}

	public String getDoctorCommissionPercentage() {
		return getProperty("doctor.commission_percentage", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putDoctorDesignation(String doctorDesignation) {
		addProperty("doctor.designation", doctorDesignation); //$NON-NLS-1$
	}

	public String getDoctorDesignation() {
		return getProperty("doctor.designation", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putDoctorOrganization(String doctorOrganization) {
		addProperty("doctor.organization", doctorOrganization); //$NON-NLS-1$
	}

	public String getDoctorOrganization() {
		return getProperty("doctor.organization", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putDoctorDepartmentId(String doctorDepartmentId) {
		addProperty("doctor.department.id", doctorDepartmentId); //$NON-NLS-1$
	}

	public String getDoctorDepartmentId() {
		return getProperty("doctor.department.id", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putDoctorDegreesAndTraining(String degreesAndTraining) {
		addProperty("doctor.degrees.and.training", degreesAndTraining); //$NON-NLS-1$
	}

	public String getDoctorDegreesAndTraining() {
		return getProperty("doctor.degrees.and.training", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putDoctorSpecialistName(String specialistName) {
		addProperty("doctor.specialist.name", specialistName); //$NON-NLS-1$
	}

	public String getDoctorSpecialistName() {
		return getProperty("doctor.specialist.name", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putDoctorScheduleToVisit(String scheduleToVisit) {
		addProperty("doctor.schedule.to.visit", scheduleToVisit); //$NON-NLS-1$
	}

	public String getDoctorScheduleToVisit() {
		return getProperty("doctor.schedule.to.visit", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putDoctorAddressLine(String doctorAddress) {
		addProperty("doctor.address.line", doctorAddress); //$NON-NLS-1$
	}

	public String getDoctorAddressLine() {
		return getProperty("doctor.address.line", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

}