/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

public enum DrawerType {
	DRAWER(0), STAFF_BANK(1);

	private int typeNumber;

	private DrawerType(int typeNumber) {
		this.typeNumber = typeNumber;
	}

	public int getTypeNumber() {
		return typeNumber;
	}

	public static DrawerType fromInt(int typeNumber) {
		DrawerType[] values = values();

		for (DrawerType transLocEnum : values) {
			if (transLocEnum.typeNumber == typeNumber) {
				return transLocEnum;
			}
		}
		return DRAWER;
	}

	@Override
	public String toString() {
		return name();
	}

	public static DrawerType getUserDrawerType(User user) {
		return user.isStaffBank() ? STAFF_BANK : DRAWER;
	}
}
