package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum AgentTypeEnum {

	//@formatter:off
	B2B("B2B"), 
	OUTDOOR_AGENT("Outdoor agent"), 
	INDOOR_AGENT("Indoor agent"), 
	INDOOR_MARKETTING_TEAM("Indoor marketting team"), 
	INDOOR_DOCTOR("Indoor doctor")
	;
	//@formatter:on

	private final String agentTypeName;

	public String getAgentTypeName() {
		return agentTypeName;
	}

	private AgentTypeEnum(String agentTypeName) {
		this.agentTypeName = agentTypeName;
	}

	public static AgentTypeEnum fromString(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}

		AgentTypeEnum[] values = values();
		for (AgentTypeEnum agentTypeEnum : values) {
			if (name.equals(agentTypeEnum.name())) {
				return agentTypeEnum;
			}
		}

		return null;
	}

	@Override
	public String toString() {
		return agentTypeName;
	}

}
