package com.floreantpos.report;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.Agent;
import com.floreantpos.model.AgentTypeEnum;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Doctor;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.AgentDAO;
import com.floreantpos.model.dao.DoctorDAO;
import com.floreantpos.model.util.ReferralCommissionUtil;

public class ReferralCommissionReportData implements Serializable {

	private String id;
	private String outletId;
	private String referralType;

	private String patientName;
	private String referralBy;
	private double receivable;
	private double due;
	private double received;
	private String reportDoctor;
	private double agentCommissionOnNetSales;
	private double agentCommissionOnReport;
	private double agentFee;

	public ReferralCommissionReportData(Ticket ticket) {
		double subtotalAmount = ticket.getSubtotalAmount();
		setId(ticket.getId());
		setOutletId(ticket.getOutletId());
		setReceivable(subtotalAmount);
		setDue(ticket.getDueAmount());
		setReceived(ticket.getPaidAmount());

		String agentId = ticket.getAgentId();
		if (StringUtils.isNotBlank(agentId)) {
			Agent agent = AgentDAO.getInstance().get(agentId);
			if (agent != null) {
				String agentType = agent.getAgentType();
				if (StringUtils.isNotBlank(agentType)) {
					setReferralType(AgentTypeEnum.fromString(agentType).getAgentTypeName());
				}
				else {
					setReferralType("Self");
				}
				setReferralBy(agent.getName());
			}
			else {
				setReferralType("Self");
				setReferralBy(""); //$NON-NLS-1$
			}

			double commissionOnReport = ReferralCommissionUtil.calculateCommissionOnReport(ticket);
			double commissionOnNetSales = ReferralCommissionUtil.calculateCommissionOnNetSales(ticket, commissionOnReport);
			setAgentCommissionOnNetSales(commissionOnNetSales);
			setAgentCommissionOnReport(commissionOnReport);
			setAgentFee(commissionOnNetSales + commissionOnReport);
		}
		else {
			setReferralType("Self");
			setReferralBy(""); //$NON-NLS-1$
		}

		String doctorId = ticket.getDoctorId();
		if (StringUtils.isNotBlank(doctorId)) {
			Doctor doctor = DoctorDAO.getInstance().get(doctorId);
			if (doctor != null) {
				setReportDoctor(doctor.getName());
			}
		}
		
		Customer customer = ticket.getCustomer();
		setPatientName(customer.getName());
	}

	public String getReferralType() {
		return referralType;
	}

	public void setReferralType(String referralType) {
		this.referralType = referralType;
	}

	public String getPatientName() {
		return patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public String getReferralBy() {
		return referralBy;
	}

	public void setReferralBy(String referralBy) {
		this.referralBy = referralBy;
	}

	public double getReceivable() {
		return receivable;
	}

	public void setReceivable(double receivable) {
		this.receivable = receivable;
	}

	public double getDue() {
		return due;
	}

	public void setDue(double due) {
		this.due = due;
	}

	public double getReceived() {
		return received;
	}

	public void setReceived(double received) {
		this.received = received;
	}

	public String getReportDoctor() {
		return reportDoctor;
	}

	public void setReportDoctor(String reportDoctor) {
		this.reportDoctor = reportDoctor;
	}

	public double getAgentCommissionOnNetSales() {
		return agentCommissionOnNetSales;
	}

	public void setAgentCommissionOnNetSales(double agentCommissionOnNetSales) {
		this.agentCommissionOnNetSales = agentCommissionOnNetSales;
	}

	public double getAgentCommissionOnReport() {
		return agentCommissionOnReport;
	}

	public void setAgentCommissionOnReport(double agentCommissionOnReport) {
		this.agentCommissionOnReport = agentCommissionOnReport;
	}

	public double getAgentFee() {
		return agentFee;
	}

	public void setAgentFee(double agentFee) {
		this.agentFee = agentFee;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

}
