package com.floreantpos.model.util;

import com.floreantpos.model.Ticket;
import com.floreantpos.util.NumberUtil;

public class ReferralCommissionUtil {

	public static double calculateCommissionOnReport(Ticket ticket) {
		double commissionOnReport = NumberUtil.parseDouble(ticket.getAgentCommissionOnReport());
		ServiceChargeType onReportChargeType = ServiceChargeType.fromName(ticket.getAgentCommissionOnReportChargeType());
		if (ServiceChargeType.PERCENTAGE.equals(onReportChargeType)) {
			commissionOnReport = calculateCommission(ticket.getSubtotalAmount(), commissionOnReport);
		}
		return commissionOnReport;
	}

	public static double calculateCommissionOnNetSales(Ticket ticket, double commissionOnReport) {
		double commissionOnNetSales = NumberUtil.parseDouble(ticket.getAgentCommissionOnNetSales());
		ServiceChargeType onNetSalesChargeType = ServiceChargeType.fromName(ticket.getAgentCommissionOnNetSalesChargeType());
		if (ServiceChargeType.PERCENTAGE.equals(onNetSalesChargeType)) {
			commissionOnNetSales = calculateCommission(ticket.getSubtotalAmount() - commissionOnReport, commissionOnNetSales);
		}
		return commissionOnNetSales;
	}

	private static double calculateCommission(double subtotalAmount, double commissionPercentage) {
		if (commissionPercentage > 0) {
			return subtotalAmount * (commissionPercentage / 100.0);
		}
		return 0d;
	}
}
