/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.Date;

import com.floreantpos.model.User;
import com.floreantpos.util.NumberUtil;

public class PayrollReportData {
	private User user;
	private Date date, clockIn, clockOut;
	private long historyWorkHourMs, regularWorkHourMs, overtimeWorkHourMs, dailyTotalWorkHourMs, previousTotalWorkHourMs;
	private double regularPayment, overtimePayment, totalPayment;
	private double costPerHour, overtimeRatePerHour;
	private String regularHourDisplay, overtimeWorkHourDisplay, totalWorkHourDisplay, totalWorkHourByUserDisplay;
	private String userIdSortKey;

	public void calculate() {
		long fromTime = clockIn.getTime();
		long toTime = clockOut.getTime();
		historyWorkHourMs = toTime - fromTime;
		long dailyWorkHourMs = (long) (user.getRegularWorkHour() * 3600000d);
		if (dailyTotalWorkHourMs < dailyWorkHourMs) {
			if (historyWorkHourMs < dailyWorkHourMs) {
				regularWorkHourMs = historyWorkHourMs;
			}
			else {
				regularWorkHourMs = dailyWorkHourMs;
				overtimeWorkHourMs = historyWorkHourMs - dailyWorkHourMs;
			}
		}
		else {
			long remainWorkhourMs = dailyWorkHourMs - previousTotalWorkHourMs;
			if (remainWorkhourMs < 0) {
				overtimeWorkHourMs = historyWorkHourMs;
			}
			else {
				if (historyWorkHourMs < remainWorkhourMs) {
					regularWorkHourMs = historyWorkHourMs;
				}
				else {
					regularWorkHourMs = remainWorkhourMs;
					overtimeWorkHourMs = historyWorkHourMs - remainWorkhourMs;
				}
			}
		}

		double regularWorkHour = regularWorkHourMs / 3600000d;
		double overtimeWorkHour = overtimeWorkHourMs / 3600000d;
		costPerHour = getCostPerHour();
		overtimeRatePerHour = getOvertimeRatePerHour();
		regularPayment = NumberUtil.round(regularWorkHour * costPerHour);
		overtimePayment = NumberUtil.round(overtimeWorkHour * overtimeRatePerHour);
		totalPayment = NumberUtil.round(regularPayment + overtimePayment);

		totalWorkHourDisplay = getHour(historyWorkHourMs) + "h " + getMin(historyWorkHourMs) + "m"; //$NON-NLS-1$ //$NON-NLS-2$
		regularHourDisplay = getHour(regularWorkHourMs) + "h " + getMin(regularWorkHourMs) + "m"; //$NON-NLS-1$ //$NON-NLS-2$
		overtimeWorkHourDisplay = getHour(overtimeWorkHourMs) + "h " + getMin(overtimeWorkHourMs) + "m"; //$NON-NLS-1$ //$NON-NLS-2$

	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public Date getClockIn() {
		return clockIn;
	}

	public void setClockIn(Date from) {
		this.clockIn = from;
	}

	public Date getClockOut() {
		return clockOut;
	}

	public void setClockOut(Date to) {
		this.clockOut = to;
	}

	public long getTotalWorkHourMs() {
		return historyWorkHourMs;
	}

	public void setTotalWorkHourMs(long totalWorkHourMs) {
		this.historyWorkHourMs = totalWorkHourMs;
	}

	public double getRegularPayment() {
		return regularPayment;
	}

	public void setRegularPayment(double regularPayment) {
		this.regularPayment = regularPayment;
	}

	public double getOvertimePayment() {
		return overtimePayment;
	}

	public void setOvertimePayment(double overtimePayment) {
		this.overtimePayment = overtimePayment;
	}

	public double getTotalPayment() {
		return totalPayment;
	}

	public void setTotalPayment(double totalPayment) {
		this.totalPayment = totalPayment;
	}

	public double getOvertimeRatePerHour() {
		Double perHour = user.getOvertimeRatePerHour();
		if (NumberUtil.isZero(perHour)) {
			User parentUser = user.getParentUser();
			if (parentUser != null) {
				return parentUser.getOvertimeRatePerHour();
			}
		}
		return perHour;
	}

	public void setOvertimeRatePerHour(double overtimeRatePerHour) {
		this.overtimeRatePerHour = overtimeRatePerHour;
	}

	public String getRegularHourDisplay() {
		return regularHourDisplay;
	}

	public void setRegularHourDisplay(String regularHourDisplay) {
		this.regularHourDisplay = regularHourDisplay;
	}

	public String getOvertimeWorkHourDisplay() {
		return overtimeWorkHourDisplay;
	}

	public void setOvertimeWorkHourDisplay(String overtimeDisplay) {
		this.overtimeWorkHourDisplay = overtimeDisplay;
	}

	public String getTotalWorkHourDisplay() {
		return totalWorkHourDisplay;
	}

	public void setTotalWorkHourDisplay(String totalHourDisplay) {
		this.totalWorkHourDisplay = totalHourDisplay;
	}

	public double getCostPerHour() {
		Double perHour = user.getCostPerHour();
		if (NumberUtil.isZero(perHour)) {
			User parentUser = user.getParentUser();
			if (parentUser != null) {
				return parentUser.getCostPerHour();
			}
		}
		return perHour;
	}

	public void setCostPerHour(double costPerHour) {
		this.costPerHour = costPerHour;
	}

	public static long getHour(long valueInMS) {
		return valueInMS / (60 * 60 * 1000);
	}

	public static long getMin(long valueInMS) {
		long hour = valueInMS / (60 * 60 * 1000);
		valueInMS = valueInMS - hour * (60 * 60 * 1000);
		return valueInMS / (60 * 1000);
	}

	public String getTotalWorkHourByUserDisplay() {
		return totalWorkHourByUserDisplay;
	}

	public void setTotalWorkHourByUserDisplay(String totalWorkHourByUserDisplay) {
		this.totalWorkHourByUserDisplay = totalWorkHourByUserDisplay;
	}

	public String getUserIdSortKey() {
		return userIdSortKey;
	}

	public void setUserIdSortKey(String sortByUserIdKey) {
		this.userIdSortKey = sortByUserIdKey;
	}

	public long getRegularWorkHourMs() {
		return regularWorkHourMs;
	}

	public void setRegularWorkHourMs(long regularWorkHourMs) {
		this.regularWorkHourMs = regularWorkHourMs;
	}

	public long getOvertimeWorkHourMs() {
		return overtimeWorkHourMs;
	}

	public void setOvertimeWorkHourMs(long overtimeWorkHourMs) {
		this.overtimeWorkHourMs = overtimeWorkHourMs;
	}

	public long getDailyTotalWorkHourMs() {
		return dailyTotalWorkHourMs;
	}

	public void setDailyTotalWorkHourMs(long dailyTotalWorkHourMs) {
		this.dailyTotalWorkHourMs = dailyTotalWorkHourMs;
	}

	public long getPreviousTotalWorkHourMs() {
		return previousTotalWorkHourMs;
	}

	public void setPreviousTotalWorkHourMs(long previousTotalWorkHourMs) {
		this.previousTotalWorkHourMs = previousTotalWorkHourMs;
	}

}
