package com.floreantpos.report.model;

import com.floreantpos.model.Ticket;
import com.floreantpos.swing.ListTableModel;

public class DoctorCommissionReportModel extends ListTableModel {
	public DoctorCommissionReportModel() {
		super(new String[] { "orderId", "total", "doctorName", "commissionPercentage", "commissionAmount" });

	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		Ticket ticket = (Ticket) rows.get(rowIndex);
		switch (columnIndex) {
			case 0:
				return ticket.getId();

			case 1:
				return ticket.getTotalAmount();

			case 2:
				return ticket.getDoctorName();

			case 3:
				//return ticket.getDoctorCommissionPercentage();
				return ticket.getAgentCommissionOnReport();

			case 4:
				return ticket.getDoctorFee();

		}
		return null;
	}

}