package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import com.floreantpos.Messages;
import com.floreantpos.model.base.BaseReservationShift;

@XmlRootElement
public class ReservationShift extends BaseReservationShift {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ReservationShift() {
	}

	/**
	 * Constructor for primary key
	 */
	public ReservationShift(java.lang.String id, java.lang.String outletId) {
		super(id, outletId);
	}

	/**
	 * Constructor for required fields
	 */
	public ReservationShift(java.lang.String id, java.lang.String outletId, java.lang.String name) {

		super(id, outletId, name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public enum DayOfWeek {
		Sunday(1), Monday(2), Tuesday(3), Wednesday(4), Thursday(5), Friday(6), Saturday(7);

		private final int value;

		DayOfWeek(int value) {
			this.value = value;
		}

		public int getValue() {
			return value;
		}

		public static DayOfWeek getDayOfWeek(int value) {
			for (DayOfWeek day : DayOfWeek.values()) {
				if (day.getValue() == value) {
					return day;
				}
			}
			return null;
		}
	}

	public String getDayOfWeekAsString() {
		String daysDisplay = ""; //$NON-NLS-1$
		String daysString = getDaysOfWeek();
		if (daysString != null) {
			String[] split = daysString.split(","); //$NON-NLS-1$
			if (split.length == 7)
				return Messages.getString("ReservationShift.2"); //$NON-NLS-1$
			if (split.length > 0) {
				for (int i = 0; i < split.length; i++) {
					int day = Integer.valueOf(split[i]);
					DayOfWeek week = DayOfWeek.getDayOfWeek(day);
					daysDisplay += week.name();
					if (i != split.length - 1) {
						daysDisplay += ","; //$NON-NLS-1$
					}
				}
			}
		}
		return daysDisplay;
	}

}