package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the INVENTORY_STOCK_UNIT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="INVENTORY_STOCK_UNIT"
 */

public abstract class BaseInventoryStockUnit  implements Comparable, Serializable {

	public static String REF = "InventoryStockUnit"; //$NON-NLS-1$
	public static String PROP_CONVERSION_VALUE = "conversionValue"; //$NON-NLS-1$
	public static String PROP_PACKAGING_UNIT = "packagingUnit"; //$NON-NLS-1$
	public static String PROP_RECIPE_UNIT = "recipeUnit"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_UNIT = "unit"; //$NON-NLS-1$
	public static String PROP_BASE_UNIT_VALUE = "baseUnitValue"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_ID = "menuItemId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$


	// constructors
	public BaseInventoryStockUnit () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseInventoryStockUnit (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.Double conversionValue;
				private java.lang.Double baseUnitValue;
				private java.lang.Boolean recipeUnit;
				private java.lang.String properties;
				private java.lang.String menuItemId;
	
	// many to one
	private com.floreantpos.model.InventoryUnit unit;
	private com.floreantpos.model.PackagingUnit packagingUnit;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: CONVERSION_VALUE
	 */

	public java.lang.Double getConversionValue () {
						return conversionValue == null ? Double.valueOf(0) : conversionValue;
		}



	/**
	 * Set the value related to the column: CONVERSION_VALUE
	 * @param conversionValue the CONVERSION_VALUE value
	 */
			public void setConversionValue (java.lang.Double conversionValue) {
			this.conversionValue = conversionValue;
	}



	/**
	 * Return the value associated with the column: BASE_UNIT_VALUE
	 */

	public java.lang.Double getBaseUnitValue () {
						return baseUnitValue == null ? Double.valueOf(0) : baseUnitValue;
		}



	/**
	 * Set the value related to the column: BASE_UNIT_VALUE
	 * @param baseUnitValue the BASE_UNIT_VALUE value
	 */
			public void setBaseUnitValue (java.lang.Double baseUnitValue) {
			this.baseUnitValue = baseUnitValue;
	}



	/**
	 * Return the value associated with the column: RECIPE_UNIT
	 */

	public java.lang.Boolean isRecipeUnit () {
					return recipeUnit == null ? Boolean.FALSE : recipeUnit;
		}

	public java.lang.Boolean getRecipeUnit () {
				return recipeUnit == null ? Boolean.FALSE : recipeUnit;
			}


	/**
	 * Set the value related to the column: RECIPE_UNIT
	 * @param recipeUnit the RECIPE_UNIT value
	 */
			public void setRecipeUnit (java.lang.Boolean recipeUnit) {
			this.recipeUnit = recipeUnit;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_ID
	 */

	public java.lang.String getMenuItemId () {
			return menuItemId;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_ID
	 * @param menuItemId the MENU_ITEM_ID value
	 */
			public void setMenuItemId (java.lang.String menuItemId) {
			this.menuItemId = menuItemId;
	}



	/**
	 * Return the value associated with the column: UNIT_ID
	 */

	public com.floreantpos.model.InventoryUnit getUnit () {
			return unit;
	}



	/**
	 * Set the value related to the column: UNIT_ID
	 * @param unit the UNIT_ID value
	 */
			public void setUnit (com.floreantpos.model.InventoryUnit unit) {
			this.unit = unit;
	}



	/**
	 * Return the value associated with the column: PACKAGING_UNIT_ID
	 */

	public com.floreantpos.model.PackagingUnit getPackagingUnit () {
			return packagingUnit;
	}



	/**
	 * Set the value related to the column: PACKAGING_UNIT_ID
	 * @param packagingUnit the PACKAGING_UNIT_ID value
	 */
			public void setPackagingUnit (com.floreantpos.model.PackagingUnit packagingUnit) {
			this.packagingUnit = packagingUnit;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.InventoryStockUnit)) return false;
		else {
			com.floreantpos.model.InventoryStockUnit inventoryStockUnit = (com.floreantpos.model.InventoryStockUnit) obj;
			if (null == this.getId() || null == inventoryStockUnit.getId()) return this == obj;
			else return (this.getId().equals(inventoryStockUnit.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}