package com.floreantpos.model.util;

import com.floreantpos.model.Ticket;
import com.floreantpos.util.NumberUtil;

public class ReferralCommissionUtil {

	@Deprecated
	public static double calculateCommissionOnReport(Ticket ticket) {
		double commissionOnReport = NumberUtil.parseDouble(ticket.getAgentCommissionRateOnReport());
		ServiceChargeType onReportChargeType = ServiceChargeType.fromName(ticket.getAgentCommissionOnReportChargeType());
		if (ServiceChargeType.PERCENTAGE.equals(onReportChargeType)) {
			commissionOnReport = calculateCommission(ticket.getSubtotalAmount(), commissionOnReport);
		}
		return commissionOnReport;
	}

	@Deprecated
	public static double calculateCommissionOnNetSales(Ticket ticket, double commissionOnReport) {
		double commissionOnNetSales = NumberUtil.parseDouble(ticket.getAgentCommissionRateOnNetSales());
		ServiceChargeType onNetSalesChargeType = ServiceChargeType.fromName(ticket.getAgentCommissionOnNetSalesChargeType());
		if (ServiceChargeType.PERCENTAGE.equals(onNetSalesChargeType)) {
			commissionOnNetSales = calculateCommission(ticket.getSubtotalAmount() - commissionOnReport, commissionOnNetSales);
		}
		return commissionOnNetSales;
	}

	public static double calculateAgentCommissionOnReport(Ticket ticket) {
		double commissionRateOnReport = NumberUtil.parseDouble(ticket.getAgentCommissionRateOnReport());
		ServiceChargeType onReportChargeType = ServiceChargeType.fromName(ticket.getAgentCommissionOnReportChargeType());
		if (ServiceChargeType.PERCENTAGE.equals(onReportChargeType)) {
			Double subtotalAmount = ticket.getSubtotalAmount() - ticket.getDiscountAmount() - ticket.getDueAmount()
					- ticket.getLabDoctorFee();
			commissionRateOnReport = calculateCommission(subtotalAmount, commissionRateOnReport);
		}
		return commissionRateOnReport;
	}

	public static double calculateAgentCommissionOnNetSales(Ticket ticket, double commissionOnReport) {
		double commissionOnNetSales = NumberUtil.parseDouble(ticket.getAgentCommissionRateOnNetSales());
		ServiceChargeType onNetSalesChargeType = ServiceChargeType.fromName(ticket.getAgentCommissionOnNetSalesChargeType());
		if (ServiceChargeType.PERCENTAGE.equals(onNetSalesChargeType)) {
			Double subtotalAmount = ticket.getSubtotalAmount() - ticket.getDiscountAmount() /*- ticket.getRefundAmount()*/ - ticket.getDueAmount()
					- ticket.getLabDoctorFee();
			commissionOnNetSales = calculateCommission(subtotalAmount - commissionOnReport, commissionOnNetSales);
		}
		return commissionOnNetSales;
	}

	private static double calculateCommission(double subtotalAmount, double commissionPercentage) {
		if (commissionPercentage > 0) {
			return subtotalAmount * (commissionPercentage / 100.0);
		}
		return 0d;
	}
}
