package com.floreantpos.report;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.Agent;
import com.floreantpos.model.AgentTypeEnum;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Doctor;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.DoctorDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.ReferralCommissionUtil;

public class LabDoctorFeeReportData implements Serializable {

	private String orderId;
	private String orderDate;
	private String outletId;
	private String patientName;
	private String testName;
	private String labDoctorName;
	private double labDoctorFee;

	public LabDoctorFeeReportData(Ticket ticket, TicketItem ticketItem) {
		setOrderId(ticket.getId());
		setOrderDate(DateUtil.formatAsShortDate(DateUtil.convertDateToBrowserTime(ticket.getCreateDate())));
		setOutletId(ticket.getOutletId());

		String doctorId = ticketItem.getLabDoctorId();
		if (StringUtils.isNotBlank(doctorId)) {
			Doctor doctor = DoctorDAO.getInstance().get(doctorId);
			if (doctor != null) {
				setLabDoctorName(doctor.getName());
			}
		}
		setTestName(ticketItem.getName());
		setLabDoctorFee(ticketItem.getLabDoctorFee());

		Customer customer = ticket.getCustomer();
		if (customer != null) {
			setPatientName(customer.getName());
		}
		
	}

	public String getPatientName() {
		return patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String id) {
		this.orderId = id;
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

	public String getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(String orderDate) {
		this.orderDate = orderDate;
	}

	public String getTestName() {
		return testName;
	}

	public void setTestName(String testName) {
		this.testName = testName;
	}

	public String getLabDoctorName() {
		return labDoctorName;
	}

	public void setLabDoctorName(String labDoctorName) {
		this.labDoctorName = labDoctorName;
	}

	public double getLabDoctorFee() {
		return labDoctorFee;
	}

	public void setLabDoctorFee(double labDoctorFee) {
		this.labDoctorFee = labDoctorFee;
	}

}
