package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import com.floreantpos.model.base.BaseModifiableTicketItem;

@XmlRootElement
public class ModifiableTicketItem extends BaseModifiableTicketItem {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ModifiableTicketItem() {
	}

	/**
	 * Constructor for primary key
	 */
	public ModifiableTicketItem(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public ModifiableTicketItem(Ticket ticket, String name, double unitPrice, double quantity, TicketItemTax tax) {
		setName(name);
		setUnitPrice(unitPrice);
		setQuantity(quantity);
		addTotaxes(tax);
		setTicket(ticket);
	}

	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.TicketItem)) return false;
		else {
			com.floreantpos.model.TicketItem ticketItem = (com.floreantpos.model.TicketItem) obj;
			if (null == this.getId() || null == ticketItem.getId()) return this == obj;
			else return (this.getId().equals(ticketItem.getId()));
		}
	}
}