package com.floreantpos.model.util.pricecalc;

import java.util.List;

import com.floreantpos.model.Discount;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.ext.UnitBaseItemPrice;
import com.floreantpos.model.util.ReferralCommissionType;

public interface DataUtilCalculator {

	TicketItem convertToTicketItem(MenuItem selectedMenuItem, Ticket ticket, double itemQuantity, boolean hasComboModifiers, IUnit destinationUnit,
			boolean checkEditablePrice, boolean useOnlinePrice);

	void setTicketItemUnitPriceAndCost(MenuItem selectedMenuItem, TicketItem ticketItem, IUnit destinationUnit, Ticket ticket, boolean checkEditablePrice,
			boolean useOnlinePrice);

	TicketItemDiscount convertToTicketItemDiscount(Discount discount, TicketItem ticketItem);

	void setItemTaxes(TicketItem ticketItem, TaxGroup itemTaxGroup, OrderType orderType);

	List<IUnit> getUnits(MenuItem selectedMenuItem, boolean includeStockUnits, boolean includeRecipeUnits, boolean skipStockNotCountableUnits);

	double getDestinationUnitPrice(MenuItem menuItem, IUnit destinationUnit, Double priceFromPriceRule, double unitQuantity);

	double getDestinationUnitPrice(Ticket ticket, MenuItem menuItem, IUnit destinationUnit, double unitQuantity);

	double getPriceFromPriceRule(MenuItem menuItem, Ticket ticket);

	Double calculateDefaultPizzaPrice(MenuItem menuItem);

	Double calculateDefaultPizzaCost(MenuItem menuItem);

	Double getCost(MenuItem menuItem, String unitId);

	Double getCost(MenuItem menuItem, IUnit selectedUnit);

	Double getVariantCost(MenuItem menuItem, IUnit selectedUnit);

	List<UnitBaseItemPrice> buildUnitBasePriceList(MenuItem menuItem, boolean regeneratePrice);

	double calculateCost(Double unitCost, IUnit sourceUnit, IUnit targetUnit, MenuItem menuItem);

	double calculatePrice(Double unitPrice, IUnit sourceUnit, IUnit targetUnit, MenuItem menuItem);

	double getBaseUnitQuantity(String unitCode, MenuItem menuItem);

	double getUnitQuantity(IUnit sourceInventoryUnit, IUnit destinationInventoryUnit, MenuItem menuItem);

	double calculateReferrerCommissionRate(Ticket ticket, ReferralCommissionType referralCommissionType, String menuGroupId);
}
