package com.floreantpos.report;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.Customer;
import com.floreantpos.model.Doctor;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.DoctorDAO;
import com.floreantpos.model.util.DateUtil;

public class LabDoctorFeeReportData implements Serializable {

	private String id;
	private String orderId;
	private Date orderDate;
	private String orderDateDisplay;
	private String outletId;
	private String patientName;
	private String testName;
	private String labDoctorName;
	private double labDoctorFee;

	public LabDoctorFeeReportData(Ticket ticket, TicketItem ticketItem) {
		setId(ticket.getId());
		setOrderId(ticket.getId());
		setOrderDate(ticket.getCreateDate());
		setOutletId(ticket.getOutletId());

		String doctorId = ticketItem.getLabDoctorId();
		if (StringUtils.isNotBlank(doctorId)) {
			Doctor doctor = DoctorDAO.getInstance().get(doctorId);
			if (doctor != null) {
				setLabDoctorName(doctor.getName());
			}
		}
		setTestName(ticketItem.getName());
		setLabDoctorFee(ticketItem.getLabDoctorFee());

		Customer customer = ticket.getCustomer();
		if (customer != null) {
			setPatientName(customer.getName());
		}
		
	}

	public String getPatientName() {
		return patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String id) {
		this.orderId = id;
	}

	public Date getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(Date orderDate) {
		this.orderDate = orderDate;
	}

	public String getOrderDateDisplay() {
		return DateUtil.formatAsShortDate(DateUtil.convertDateToBrowserTime(getOrderDate()));
	}

	public void setOrderDateDisplay(String orderDateDisplay) {
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

	public String getTestName() {
		return testName;
	}

	public void setTestName(String testName) {
		this.testName = testName;
	}

	public String getLabDoctorName() {
		return labDoctorName;
	}

	public void setLabDoctorName(String labDoctorName) {
		this.labDoctorName = labDoctorName;
	}

	public double getLabDoctorFee() {
		return labDoctorFee;
	}

	public void setLabDoctorFee(double labDoctorFee) {
		this.labDoctorFee = labDoctorFee;
	}

}
