package com.floreantpos.util;


import org.apache.commons.codec.binary.Base64;

import java.security.Key;

import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESencrp2 {

	private static final String ALGO = "AES/GCM/NoPadding"; //$NON-NLS-1$
	private static final byte[] keyValue = new byte[] { 'T', 'h', 'e', 'B', 'e', 's', 't',

	'S', 'e', 'c', 'r', 'e', 't', 'K', 'e', 'y' };

	public static String encrypt(String Data) throws Exception {
		Key key = generateKey();
		Cipher c = Cipher.getInstance(ALGO);
		GCMParameterSpec paramSpec = new GCMParameterSpec(128, generateIv());
		c.init(Cipher.ENCRYPT_MODE, key, paramSpec);
		byte[] encVal = c.doFinal(Data.getBytes());
		Base64 base64 = new Base64();
		String encryptedValue = base64.encodeToString(encVal);
		return encryptedValue;
	}

	public static String decrypt(String encryptedData) throws Exception {
		Key key = generateKey();
		Cipher c = Cipher.getInstance(ALGO);
		GCMParameterSpec paramSpec = new GCMParameterSpec(128, generateIv());
		c.init(Cipher.DECRYPT_MODE, key, paramSpec);
		Base64 base64 = new Base64();
		byte[] decordedValue = base64.decode(encryptedData);
		byte[] decValue = c.doFinal(decordedValue);
		String decryptedValue = new String(decValue);
		return decryptedValue;
	}

	private static Key generateKey() {
		Key key = new SecretKeySpec(keyValue, "AES");
		return key;
	}

	private static byte[] generateIv() {
		return "Orocube".getBytes();
	}
	
	/**
	 * Siiopa uses algorithm "AES/GCM/NoPadding" due to google's restriction. Encryption
	 * and decryption using that algorithm in class AESencryp2. However old code uses only
	 * "AES" algorithm using AESencrypt class and all saved passwords use AESencrypt class.
	 * 
	 * Hence a password coming from Siiopa must be checked using both old and new algorithm, that is
	 * both AESeccrypt and AESencrypt2 class.
	 * 
	 * 
	 * @param oldKey password saved in database
	 * @param newKey password coming from siiopa/oropos or other apps.
	 * @return
	 * @throws Exception
	 */
	public static boolean matchOldKey(String oldKey, String newKey) throws Exception {
		String decryptedOldKey = AESencrp.decrypt(oldKey);
		String encryptedOldKey = AESencrp2.encrypt(decryptedOldKey);
		
		return newKey.equals(encryptedOldKey);
	}

	/**
	 * Siiopa uses algorithm "AES/GCM/NoPadding" due to google's restriction. Encryption
	 * and decryption using that algorithm in class AESencryp2. However old code uses only
	 * "AES" algorithm using AESencrypt class and all saved passwords use AESencrypt class.
	 * 
	 * Hence a password coming from Siiopa must be checked using both old and new algorithm, that is
	 * both AESeccrypt and AESencrypt2 class.
	 * 
	 * @param storedPassword password saved in database
	 * @param suppliedPassword password coming from siiopa/oropos or other apps.
	 * @return
	 * @throws Exception
	 */
	public static boolean passwordMatched(String storedPassword, String suppliedPassword) throws Exception {
		if (suppliedPassword.equals(storedPassword)) {
			return true;
		}
		
		return matchOldKey(storedPassword, suppliedPassword);
	}
}
