package com.floreantpos.model.dao;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.TestItem;

public class TestItemDAO extends BaseTestItemDAO {

	public TestItemDAO() {
	}

	public List<String> findTestItemUnits() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(TestItem.class);
			criteria.setProjection(Projections.distinct(Projections.property(TestItem.PROP_UNIT)));
			criteria.add(Restrictions.neOrIsNotNull(TestItem.PROP_UNIT, "")); //$NON-NLS-1$
			criteria.addOrder(Order.asc(TestItem.PROP_UNIT));
			List<String> list = criteria.list();
			return list;
		}
	}

}