package com.floreantpos.model.util.pricecalc;

import java.lang.reflect.Method;

public class DataUtilCalcFactory {
	private static DataUtilCalculator dataUtilCalculator;

	public static DataUtilCalculator getCalc() {
		try {
			if (dataUtilCalculator != null) {
				return dataUtilCalculator;
			}

			Class<?> clazz = Class.forName("com.orocube.pos.pricecalc.DataUtilCalc"); //$NON-NLS-1$
			Method method = clazz.getMethod("getInstance"); //$NON-NLS-1$
			dataUtilCalculator = (DataUtilCalculator) method.invoke(null);
			return dataUtilCalculator;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
