package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BasePurchaseOrderItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "menuItem", "purchaseOrder" })
public class PurchaseOrderItem extends BasePurchaseOrderItem implements PropertyContainer {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public PurchaseOrderItem() {
	}

	/**
	 * Constructor for primary key
	 */
	public PurchaseOrderItem(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public PurchaseOrderItem(java.lang.String id, com.floreantpos.model.PurchaseOrder purchaseOrder) {

		super(id, purchaseOrder);
	}

	/*[CONSTRUCTOR MARKER END]*/

	private Double quantityToReceive;
	private MenuItem menuItem;
	private transient com.google.gson.JsonObject propertiesContainer;
	private String unitCodeDisplay;

	public void calculatePrice() {
		setSubtotalAmount((getUnitPrice() * getItemQuantity()));
		setTotalAmount((getSubtotalAmount() + getTaxAmount() - getDiscountAmount()));
	}

	public String getQuantityDisplay() {
		return NumberUtil.format6DigitNumber(super.getItemQuantity());
	}

	public String getPriceDisplay() {
		return NumberUtil.getCurrencyFormatWithoutCurrencySymbol(super.getUnitPrice());
	}

	public String getTotalDisplay() {
		return NumberUtil.getCurrencyFormatWithoutCurrencySymbol(super.getTotalAmount());
	}

	public Double getQuantityToReceive() {
		return quantityToReceive == null ? Double.valueOf(0) : quantityToReceive;
	}

	public void setQuantityToReceive(Double quantityToReceive) {
		this.quantityToReceive = quantityToReceive;
	}

	@Override
	public void addProperty(String key, String value) {
		initPropertyContainer();
		propertiesContainer.addProperty(key, value);
		super.setProperties(propertiesContainer.toString());
	}

	@Override
	public String getProperty(String key) {
		initPropertyContainer();

		if (propertiesContainer.has(key)) {
			JsonElement jsonElement = propertiesContainer.get(key);
			if (!jsonElement.isJsonNull()) {
				return jsonElement.getAsString();
			}
		}
		return null;
	}

	@Override
	public boolean hasProperty(String key) {
		return getProperty(key) != null;
	}

	public boolean isPropertyValueTrue(String propertyName) {
		String property = getProperty(propertyName);

		return POSUtil.getBoolean(property);
	}

	@Override
	public void removeProperty(String propertyName) {
		initPropertyContainer();
		propertiesContainer.remove(propertyName);
		super.setProperties(propertiesContainer.toString());
	}

	@Override
	public com.google.gson.JsonObject getPropertyStore() {
		initPropertyContainer();
		return propertiesContainer;
	}

	private void initPropertyContainer() {
		if (propertiesContainer == null) {
			if (StringUtils.isBlank(super.getProperties())) {
				propertiesContainer = new com.google.gson.JsonObject();
			}
			else {
				propertiesContainer = new Gson().fromJson(super.getProperties(), com.google.gson.JsonObject.class);
			}
		}
	}

	@XmlTransient
	public MenuItem getMenuItem() {
		if (menuItem == null) {
			String itemId = getMenuItemId();
			if (StringUtils.isEmpty(itemId)) {
				return null;
			}
			menuItem = MenuItemDAO.getInstance().loadInitialized(itemId);
		}

		return menuItem;
	}

	public void setMenuItem(MenuItem menuItem) {
		this.menuItem = menuItem;
	}

	public String getUnitCodeDisplay() {
		return unitCodeDisplay;
	}

	public void setUnitCodeDisplay(String unitName) {
		this.unitCodeDisplay = unitName;
	}
}