package com.floreantpos.model.dao;

import java.util.Date;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.LdfPayTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;

public class LdfPayTransactionDAO extends BaseLdfPayTransactionDAO {

	public LdfPayTransactionDAO() {
	}

	public void createLdfPayTransaction(Ticket ticket, Customer referrer, double payoutAmount, CustomPayment customPayment, String customPaymnetRef,
			User currentUser, Terminal drawerTerminal, CashDrawer cashDrawer, Session session) throws Exception {
		if (referrer == null) {
			return;
		}

		StoreSession storeSession = DataProvider.get().getStoreSession();
		if (storeSession == null && cashDrawer != null) {
			storeSession = cashDrawer.getStoreSession();
		}

		LdfPayTransaction ldfPayTransaction = new LdfPayTransaction();

		if (customPayment != null) {
			ldfPayTransaction.setPaymentType(PaymentType.CUSTOM_PAYMENT);
			ldfPayTransaction.setCustomPaymentId(customPayment.getId());
			ldfPayTransaction.setCustomPaymentRef(customPaymnetRef);
		}
		else {
			ldfPayTransaction.setPaymentType(PaymentType.CASH);
		}
		ldfPayTransaction.setTransactionType(TransactionType.OUT.name());
		ldfPayTransaction.setAmount(Double.valueOf(payoutAmount));
		ldfPayTransaction.setCustomerId(referrer.getId());
		ldfPayTransaction.setCashDrawer(cashDrawer);
		if (storeSession != null) {
			ldfPayTransaction.setStoreSessionId(storeSession.getId());
		}
		
		ldfPayTransaction.setTransTicketId(ticket.getId());
		ldfPayTransaction.setOutletId(DataProvider.get().getOutletId());
		ldfPayTransaction.setUser(currentUser);
		ldfPayTransaction.setServer(currentUser);
		ldfPayTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
		ldfPayTransaction.setTerminal(drawerTerminal);

		saveOrUpdate(ldfPayTransaction, session);
		logJournal(currentUser, ticket, ldfPayTransaction, payoutAmount, cashDrawer, drawerTerminal, session);
	}

	private void logJournal(User currentUser, Ticket ticket, LdfPayTransaction ldfPayTransaction, double rfAmount, CashDrawer currentCashDrawer,
			Terminal drawerTerminal, Session session) {
		try {
			String actionMessage = String.format("Terminal id : %s, Cash drawer id : %s, Total : %s", drawerTerminal.getId(), currentCashDrawer.getId(), //$NON-NLS-1$
					NumberUtil.formatNumber(rfAmount));
			ActionHistoryDAO.saveHistory(currentUser, ticket, ldfPayTransaction, ActionHistory.LDF_PAY, actionMessage, session);
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

	public List<LdfPayTransaction> findLDFPayments(Date startTime, Date endTime, Customer referrer) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(LdfPayTransaction.class);
			criteria.add(Restrictions.eq(LdfPayTransaction.PROP_VOIDED, false));

			if (referrer != null) {
				criteria.add(Restrictions.eq(LdfPayTransaction.PROP_CUSTOMER_ID, referrer.getId()));
			}
			criteria.add(Restrictions.between(LdfPayTransaction.PROP_TRANSACTION_TIME, DateUtil.startOfDay(startTime), DateUtil.endOfDay(endTime)));
			criteria.addOrder(Order.desc(LdfPayTransaction.PROP_TRANSACTION_TIME));
			return criteria.list();
		}
	}

}