package com.floreantpos.model.dao;

import java.util.Date;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.RfPayTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;

public class RfPayTransactionDAO extends BaseRfPayTransactionDAO {

	public RfPayTransactionDAO() {
	}

	public void createRfPayTransaction(Ticket ticket, Customer referrer, double payoutAmount, CustomPayment customPayment, String customPaymnetRef,
			User currentUser, Terminal drawerTerminal, CashDrawer cashDrawer, Session session) throws Exception {
		if (referrer == null) {
			return;
		}

		StoreSession storeSession = DataProvider.get().getStoreSession();
		if (storeSession == null && cashDrawer != null) {
			storeSession = cashDrawer.getStoreSession();
		}

		RfPayTransaction rfPayTransaction = new RfPayTransaction();

		if (customPayment != null) {
			rfPayTransaction.setPaymentType(PaymentType.CUSTOM_PAYMENT);
			rfPayTransaction.setCustomPaymentId(customPayment.getId());
			rfPayTransaction.setCustomPaymentRef(customPaymnetRef);
		}
		else {
			rfPayTransaction.setPaymentType(PaymentType.CASH);
		}
		rfPayTransaction.setTransactionType(TransactionType.OUT.name());
		rfPayTransaction.setAmount(Double.valueOf(payoutAmount));
		rfPayTransaction.setCustomerId(referrer.getId());
		rfPayTransaction.setCashDrawer(cashDrawer);
		if (storeSession != null) {
			rfPayTransaction.setStoreSessionId(storeSession.getId());
		}
		rfPayTransaction.setTransTicketId(ticket.getId());
		rfPayTransaction.setOutletId(DataProvider.get().getOutletId());
		rfPayTransaction.setUser(currentUser);
		rfPayTransaction.setServer(currentUser);
		rfPayTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
		rfPayTransaction.setTerminal(drawerTerminal);

		saveOrUpdate(rfPayTransaction, session);
		logJournal(currentUser, ticket, rfPayTransaction, payoutAmount, cashDrawer, drawerTerminal, session);
	}

	private void logJournal(User currentUser, Ticket ticket, RfPayTransaction rfPayTransaction, double rfAmount, CashDrawer currentCashDrawer,
			Terminal drawerTerminal, Session session) {
		try {
			String actionMessage = String.format("Terminal id : %s, Cash drawer id : %s, Total : %s", drawerTerminal.getId(), currentCashDrawer.getId(), //$NON-NLS-1$
					NumberUtil.formatNumber(rfAmount));
			ActionHistoryDAO.saveHistory(currentUser, ticket, rfPayTransaction, ActionHistory.RF_PAY, actionMessage, session);
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

	public List<RfPayTransaction> findRFPayments(Date startTime, Date endTime, Customer referrer) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(RfPayTransaction.class);
			criteria.add(Restrictions.eq(RfPayTransaction.PROP_VOIDED, false));

			if (referrer != null) {
				criteria.add(Restrictions.eq(RfPayTransaction.PROP_CUSTOMER_ID, referrer.getId()));
			}
			criteria.add(Restrictions.between(RfPayTransaction.PROP_TRANSACTION_TIME, DateUtil.startOfDay(startTime), DateUtil.endOfDay(endTime)));
			criteria.addOrder(Order.desc(RfPayTransaction.PROP_TRANSACTION_TIME));
			return criteria.list();
		}
	}
}