package com.floreantpos.report;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.Customer;
import com.floreantpos.model.Doctor;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.DoctorDAO;
import com.floreantpos.model.util.DateUtil;

public class LabDoctorFeeReportData implements Serializable {

	private String id;
	private String orderId;
	private Date orderDate;
	//private String orderDateDisplay;
	private String outletId;
	private String patientName;
	private String testName;
	private String labDoctorId;
	private String labDoctorName;
	private String labDoctorDepartment;
	private String labDoctorPhone;
	private double labDoctorFee;
	private double labDoctorFeePaidAmount;
	private double labDoctorFeeDueAmount;

	public LabDoctorFeeReportData() {

	}

	public LabDoctorFeeReportData(Ticket ticket, TicketItem ticketItem) {
		setId(ticket.getId());
		setOrderId(ticket.getId());
		setOrderDate(ticket.getCreateDate());
		setOutletId(ticket.getOutletId());

		String doctorId = ticketItem.getLabDoctorId();
		Doctor doctor = DoctorDAO.getInstance().get(doctorId);
		if (StringUtils.isNotBlank(doctorId)) {
			setLabDoctorId(doctorId);
			if (doctor != null) {
				setLabDoctorName(doctor.getName());
				String departmentName = doctor.getDepartmentName();
				if (departmentName != null) {
					setLabDoctorDepartment(departmentName);
				}
				String phone = doctor.getMobileNo();
				if (phone != null) {
					setLabDoctorPhone(phone);
				}
			}
		}

		setTestName(ticketItem.getName());
		setLabDoctorFee(ticketItem.getLabDoctorFee());

		setLabDoctorFeePaidAmount(ticketItem.getLabDoctorFeePaidAmount());

		double labDoctoreFeeDueAmount = ticketItem.getLabDoctorFee() - ticketItem.getLabDoctorFeePaidAmount();
		setLabDoctorFeeDueAmount(labDoctoreFeeDueAmount);

		Customer customer = ticket.getCustomer();
		if (customer != null) {
			setPatientName(customer.getName());
		}

	}

	public String getPatientName() {
		return patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String id) {
		this.orderId = id;
	}

	public String getLabDoctorId() {
		return labDoctorId;
	}

	public void setLabDoctorId(String labDoctorId) {
		this.labDoctorId = labDoctorId;
	}

	public Date getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(Date orderDate) {
		this.orderDate = orderDate;
	}

	public String getOrderDateDisplay() {
		return DateUtil.formatAsShortDate(DateUtil.convertDateToBrowserTime(getOrderDate()));
	}

	public void setOrderDateDisplay(String orderDateDisplay) {
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

	public String getTestName() {
		return testName;
	}

	public void setTestName(String testName) {
		this.testName = testName;
	}

	public String getLabDoctorName() {
		return labDoctorName;
	}

	public void setLabDoctorName(String labDoctorName) {
		this.labDoctorName = labDoctorName;
	}

	public double getLabDoctorFee() {
		return labDoctorFee;
	}

	public void setLabDoctorFee(double labDoctorFee) {
		this.labDoctorFee = labDoctorFee;
	}

	public String getLabDoctorDepartment() {
		return labDoctorDepartment;
	}

	public void setLabDoctorDepartment(String labDoctorDepartment) {
		this.labDoctorDepartment = labDoctorDepartment;
	}

	public String getLabDoctorPhone() {
		return labDoctorPhone;
	}

	public void setLabDoctorPhone(String labDoctorPhone) {
		this.labDoctorPhone = labDoctorPhone;
	}

	public double getLabDoctorFeePaidAmount() {
		return labDoctorFeePaidAmount;
	}

	public void setLabDoctorFeePaidAmount(double labDoctorFeePaidAmount) {
		this.labDoctorFeePaidAmount = labDoctorFeePaidAmount;
	}

	public double getLabDoctorFeeDueAmount() {
		return labDoctorFeeDueAmount;
	}

	public void setLabDoctorFeeDueAmount(double labDoctorFeeDueAmount) {
		this.labDoctorFeeDueAmount = labDoctorFeeDueAmount;
	}

}
