package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the MENU_CATEGORY table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MENU_CATEGORY"
 */

public abstract class BaseMenuCategory  implements Comparable, Serializable {

	public static String REF = "MenuCategory"; //$NON-NLS-1$
	public static String PROP_ONLINE_ORDERING_ENABLE = "onlineOrderingEnable"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_HAS_SYNC_ERROR = "hasSyncError"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_TEXT_COLOR_CODE = "textColorCode"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_TRANSLATED_NAME = "translatedName"; //$NON-NLS-1$
	public static String PROP_CLOUD_SYNCED = "cloudSynced"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_VISIBLE = "visible"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_BEVERAGE = "beverage"; //$NON-NLS-1$
	public static String PROP_BUTTON_COLOR_CODE = "buttonColorCode"; //$NON-NLS-1$


	// constructors
	public BaseMenuCategory () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseMenuCategory (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseMenuCategory (
		java.lang.String id,
		java.lang.String name) {

		this.setId(id);
		this.setName(name);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.String translatedName;
				private java.lang.Boolean visible;
				private java.lang.Boolean beverage;
				private java.lang.Integer sortOrder;
				private java.lang.Integer buttonColorCode;
				private java.lang.Integer textColorCode;
				private java.lang.Boolean onlineOrderingEnable;
				private java.lang.Boolean cloudSynced;
				private java.lang.Boolean hasSyncError;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	
	// collections
	private java.util.List<com.floreantpos.model.MenuGroup> menuGroups;
	private java.util.Set<com.floreantpos.model.OrderType> orderTypes;
	private java.util.Set<com.floreantpos.model.Department> departments;
	private java.util.Set<com.floreantpos.model.TerminalType> terminalTypes;
	private java.util.Set<com.floreantpos.model.MenuShift> menuShifts;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.NameBaseIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: TRANSLATED_NAME
	 */

	public java.lang.String getTranslatedName () {
			return translatedName;
	}



	/**
	 * Set the value related to the column: TRANSLATED_NAME
	 * @param translatedName the TRANSLATED_NAME value
	 */
			public void setTranslatedName (java.lang.String translatedName) {
			this.translatedName = translatedName;
	}



	/**
	 * Return the value associated with the column: VISIBLE
	 */

	public java.lang.Boolean isVisible () {
						return visible == null ? Boolean.valueOf(true) : visible;
			}

	public java.lang.Boolean getVisible () {
					return visible == null ? Boolean.valueOf(true) : visible;
			}


	/**
	 * Set the value related to the column: VISIBLE
	 * @param visible the VISIBLE value
	 */
			public void setVisible (java.lang.Boolean visible) {
			this.visible = visible;
	}


	/**
	 * Custom property
	 */
	public static String getVisibleDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: BEVERAGE
	 */

	public java.lang.Boolean isBeverage () {
					return beverage == null ? Boolean.FALSE : beverage;
		}

	public java.lang.Boolean getBeverage () {
				return beverage == null ? Boolean.FALSE : beverage;
			}


	/**
	 * Set the value related to the column: BEVERAGE
	 * @param beverage the BEVERAGE value
	 */
			public void setBeverage (java.lang.Boolean beverage) {
			this.beverage = beverage;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: BTN_COLOR
	 */

	public java.lang.Integer getButtonColorCode () {
						return buttonColorCode == null ? Integer.valueOf(0) : buttonColorCode;
		}



	/**
	 * Set the value related to the column: BTN_COLOR
	 * @param buttonColorCode the BTN_COLOR value
	 */
			public void setButtonColorCode (java.lang.Integer buttonColorCode) {
			this.buttonColorCode = buttonColorCode;
	}



	/**
	 * Return the value associated with the column: TEXT_COLOR
	 */

	public java.lang.Integer getTextColorCode () {
						return textColorCode == null ? Integer.valueOf(0) : textColorCode;
		}



	/**
	 * Set the value related to the column: TEXT_COLOR
	 * @param textColorCode the TEXT_COLOR value
	 */
			public void setTextColorCode (java.lang.Integer textColorCode) {
			this.textColorCode = textColorCode;
	}



	/**
	 * Return the value associated with the column: ONLINE_ENABLED
	 */

	public java.lang.Boolean isOnlineOrderingEnable () {
					return onlineOrderingEnable == null ? Boolean.FALSE : onlineOrderingEnable;
		}

	public java.lang.Boolean getOnlineOrderingEnable () {
				return onlineOrderingEnable == null ? Boolean.FALSE : onlineOrderingEnable;
			}


	/**
	 * Set the value related to the column: ONLINE_ENABLED
	 * @param onlineOrderingEnable the ONLINE_ENABLED value
	 */
			public void setOnlineOrderingEnable (java.lang.Boolean onlineOrderingEnable) {
			this.onlineOrderingEnable = onlineOrderingEnable;
	}



	/**
	 * Return the value associated with the column: CLOUD_SYNCED
	 */

	public java.lang.Boolean isCloudSynced () {
					return cloudSynced == null ? Boolean.FALSE : cloudSynced;
		}

	public java.lang.Boolean getCloudSynced () {
				return cloudSynced == null ? Boolean.FALSE : cloudSynced;
			}


	/**
	 * Set the value related to the column: CLOUD_SYNCED
	 * @param cloudSynced the CLOUD_SYNCED value
	 */
			public void setCloudSynced (java.lang.Boolean cloudSynced) {
			this.cloudSynced = cloudSynced;
	}



	/**
	 * Return the value associated with the column: HAS_SYNC_ERROR
	 */

	public java.lang.Boolean isHasSyncError () {
					return hasSyncError == null ? Boolean.FALSE : hasSyncError;
		}

	public java.lang.Boolean getHasSyncError () {
				return hasSyncError == null ? Boolean.FALSE : hasSyncError;
			}


	/**
	 * Set the value related to the column: HAS_SYNC_ERROR
	 * @param hasSyncError the HAS_SYNC_ERROR value
	 */
			public void setHasSyncError (java.lang.Boolean hasSyncError) {
			this.hasSyncError = hasSyncError;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: menuGroups
	 */

	public java.util.List<com.floreantpos.model.MenuGroup> getMenuGroups () {
			return menuGroups;
	}



	/**
	 * Set the value related to the column: menuGroups
	 * @param menuGroups the menuGroups value
	 */
			public void setMenuGroups (java.util.List<com.floreantpos.model.MenuGroup> menuGroups) {
			this.menuGroups = menuGroups;
	}

	public void addTomenuGroups (com.floreantpos.model.MenuGroup menuGroup) {
		if (null == getMenuGroups()) setMenuGroups(new java.util.ArrayList<com.floreantpos.model.MenuGroup>());
		getMenuGroups().add(menuGroup);
	}



	/**
	 * Return the value associated with the column: orderTypes
	 */

	public java.util.Set<com.floreantpos.model.OrderType> getOrderTypes () {
			return orderTypes;
	}



	/**
	 * Set the value related to the column: orderTypes
	 * @param orderTypes the orderTypes value
	 */
			public void setOrderTypes (java.util.Set<com.floreantpos.model.OrderType> orderTypes) {
			this.orderTypes = orderTypes;
	}

	public void addToorderTypes (com.floreantpos.model.OrderType orderType) {
		if (null == getOrderTypes()) setOrderTypes(new java.util.TreeSet<com.floreantpos.model.OrderType>());
		getOrderTypes().add(orderType);
	}



	/**
	 * Return the value associated with the column: departments
	 */

	public java.util.Set<com.floreantpos.model.Department> getDepartments () {
			return departments;
	}



	/**
	 * Set the value related to the column: departments
	 * @param departments the departments value
	 */
			public void setDepartments (java.util.Set<com.floreantpos.model.Department> departments) {
			this.departments = departments;
	}

	public void addTodepartments (com.floreantpos.model.Department department) {
		if (null == getDepartments()) setDepartments(new java.util.TreeSet<com.floreantpos.model.Department>());
		getDepartments().add(department);
	}



	/**
	 * Return the value associated with the column: terminalTypes
	 */

	public java.util.Set<com.floreantpos.model.TerminalType> getTerminalTypes () {
			return terminalTypes;
	}



	/**
	 * Set the value related to the column: terminalTypes
	 * @param terminalTypes the terminalTypes value
	 */
			public void setTerminalTypes (java.util.Set<com.floreantpos.model.TerminalType> terminalTypes) {
			this.terminalTypes = terminalTypes;
	}

	public void addToterminalTypes (com.floreantpos.model.TerminalType terminalType) {
		if (null == getTerminalTypes()) setTerminalTypes(new java.util.TreeSet<com.floreantpos.model.TerminalType>());
		getTerminalTypes().add(terminalType);
	}



	/**
	 * Return the value associated with the column: menuShifts
	 */

	public java.util.Set<com.floreantpos.model.MenuShift> getMenuShifts () {
			return menuShifts;
	}



	/**
	 * Set the value related to the column: menuShifts
	 * @param menuShifts the menuShifts value
	 */
			public void setMenuShifts (java.util.Set<com.floreantpos.model.MenuShift> menuShifts) {
			this.menuShifts = menuShifts;
	}

	public void addTomenuShifts (com.floreantpos.model.MenuShift menuShift) {
		if (null == getMenuShifts()) setMenuShifts(new java.util.TreeSet<com.floreantpos.model.MenuShift>());
		getMenuShifts().add(menuShift);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.MenuCategory)) return false;
		else {
			com.floreantpos.model.MenuCategory menuCategory = (com.floreantpos.model.MenuCategory) obj;
			if (null == this.getId() || null == menuCategory.getId()) return this == obj;
			else return (this.getId().equals(menuCategory.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}