package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the TICKET_ITEM_MODIFIER table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="TICKET_ITEM_MODIFIER"
 */

public abstract class BaseTicketItemModifier  implements Comparable, Serializable {

	public static String REF = "TicketItemModifier"; //$NON-NLS-1$
	public static String PROP_SHOULD_PRINT_TO_KITCHEN = "shouldPrintToKitchen"; //$NON-NLS-1$
	public static String PROP_TICKET_ITEM = "ticketItem"; //$NON-NLS-1$
	public static String PROP_TAX_INCLUDED = "taxIncluded"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_ITEM_ID = "itemId"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_TAXES_PROPERTY = "taxesProperty"; //$NON-NLS-1$
	public static String PROP_TOTAL_COST = "totalCost"; //$NON-NLS-1$
	public static String PROP_TAX_AMOUNT = "taxAmount"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE = "serviceCharge"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_DISCOUNT = "adjustedDiscount"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_TOTAL = "adjustedTotal"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_SUBTOTAL = "adjustedSubtotal"; //$NON-NLS-1$
	public static String PROP_SHOULD_SECTION_WISE_PRICE = "shouldSectionWisePrice"; //$NON-NLS-1$
	public static String PROP_ITEM_COUNT = "itemCount"; //$NON-NLS-1$
	public static String PROP_MODIFIER_TYPE = "modifierType"; //$NON-NLS-1$
	public static String PROP_TAX_EXEMPT_AMOUNT = "taxExemptAmount"; //$NON-NLS-1$
	public static String PROP_SECTION_NAME = "sectionName"; //$NON-NLS-1$
	public static String PROP_PRINTED_TO_KITCHEN = "printedToKitchen"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_TAX = "adjustedTax"; //$NON-NLS-1$
	public static String PROP_IS_DEFAULT = "isDefault"; //$NON-NLS-1$
	public static String PROP_MULTIPLIER_NAME = "multiplierName"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_ADJUSTED_UNIT_PRICE = "adjustedUnitPrice"; //$NON-NLS-1$
	public static String PROP_INFO_ONLY = "infoOnly"; //$NON-NLS-1$
	public static String PROP_TOTAL_AMOUNT = "totalAmount"; //$NON-NLS-1$
	public static String PROP_PAGE_ITEM_ID = "pageItemId"; //$NON-NLS-1$
	public static String PROP_DISCOUNT_AMOUNT = "discountAmount"; //$NON-NLS-1$
	public static String PROP_GROUP_ID = "groupId"; //$NON-NLS-1$
	public static String PROP_UNIT_COST = "unitCost"; //$NON-NLS-1$
	public static String PROP_UNIT_PRICE = "unitPrice"; //$NON-NLS-1$
	public static String PROP_ITEM_QUANTITY = "itemQuantity"; //$NON-NLS-1$
	public static String PROP_FRACTIONAL_UNIT = "fractionalUnit"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_IS_DEFAULT_MODIFIER = "isDefaultModifier"; //$NON-NLS-1$
	public static String PROP_SUB_TOTAL_AMOUNT = "subTotalAmount"; //$NON-NLS-1$


	// constructors
	public BaseTicketItemModifier () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseTicketItemModifier (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.lang.String itemId;
				private java.lang.String groupId;
				private java.lang.String pageItemId;
				private java.lang.Integer itemCount;
				private java.lang.Double itemQuantity;
				private java.lang.String name;
				private java.lang.Double unitPrice;
				private java.lang.Double unitCost;
				private java.lang.Double totalCost;
				private java.lang.Integer modifierType;
				private java.lang.Double subTotalAmount;
				private java.lang.Double discountAmount;
				private java.lang.Double taxAmount;
				private java.lang.Double taxExemptAmount;
				private java.lang.Double serviceCharge;
				private java.lang.Double totalAmount;
				private java.lang.Boolean taxIncluded;
				private java.lang.Double adjustedUnitPrice;
				private java.lang.Double adjustedDiscount;
				private java.lang.Double adjustedSubtotal;
				private java.lang.Double adjustedTax;
				private java.lang.Double adjustedTotal;
				private java.lang.Boolean infoOnly;
				private java.lang.Boolean isDefault;
				private java.lang.String sectionName;
				private java.lang.String multiplierName;
				private java.lang.Boolean shouldPrintToKitchen;
				private java.lang.String status;
				private java.lang.Boolean shouldSectionWisePrice;
				private java.lang.Boolean fractionalUnit;
				private java.lang.Boolean printedToKitchen;
				private java.lang.Boolean isDefaultModifier;
				private java.lang.String taxesProperty;
				private java.lang.String properties;
	
	// many to one
	private com.floreantpos.model.TicketItem ticketItem;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: ITEM_ID
	 */

	public java.lang.String getItemId () {
			return itemId;
	}



	/**
	 * Set the value related to the column: ITEM_ID
	 * @param itemId the ITEM_ID value
	 */
			public void setItemId (java.lang.String itemId) {
			this.itemId = itemId;
	}



	/**
	 * Return the value associated with the column: GROUP_ID
	 */

	public java.lang.String getGroupId () {
			return groupId;
	}



	/**
	 * Set the value related to the column: GROUP_ID
	 * @param groupId the GROUP_ID value
	 */
			public void setGroupId (java.lang.String groupId) {
			this.groupId = groupId;
	}



	/**
	 * Return the value associated with the column: PAGE_ITEM_ID
	 */

	public java.lang.String getPageItemId () {
			return pageItemId;
	}



	/**
	 * Set the value related to the column: PAGE_ITEM_ID
	 * @param pageItemId the PAGE_ITEM_ID value
	 */
			public void setPageItemId (java.lang.String pageItemId) {
			this.pageItemId = pageItemId;
	}



	/**
	 * Return the value associated with the column: ITEM_COUNT
	 */

	public java.lang.Integer getItemCount () {
						return itemCount == null ? Integer.valueOf(0) : itemCount;
		}



	/**
	 * Set the value related to the column: ITEM_COUNT
	 * @param itemCount the ITEM_COUNT value
	 */
			public void setItemCount (java.lang.Integer itemCount) {
			this.itemCount = itemCount;
	}



	/**
	 * Return the value associated with the column: ITEM_QUANTITY
	 */

	public java.lang.Double getItemQuantity () {
						return itemQuantity == null ? Double.valueOf(0) : itemQuantity;
		}



	/**
	 * Set the value related to the column: ITEM_QUANTITY
	 * @param itemQuantity the ITEM_QUANTITY value
	 */
			public void setItemQuantity (java.lang.Double itemQuantity) {
			this.itemQuantity = itemQuantity;
	}



	/**
	 * Return the value associated with the column: MODIFIER_NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: MODIFIER_NAME
	 * @param name the MODIFIER_NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: MODIFIER_PRICE
	 */

	public java.lang.Double getUnitPrice () {
						return unitPrice == null ? Double.valueOf(0) : unitPrice;
		}



	/**
	 * Set the value related to the column: MODIFIER_PRICE
	 * @param unitPrice the MODIFIER_PRICE value
	 */
			public void setUnitPrice (java.lang.Double unitPrice) {
			this.unitPrice = unitPrice;
	}



	/**
	 * Return the value associated with the column: UNIT_COST
	 */

	public java.lang.Double getUnitCost () {
						return unitCost == null ? Double.valueOf(0) : unitCost;
		}



	/**
	 * Set the value related to the column: UNIT_COST
	 * @param unitCost the UNIT_COST value
	 */
			public void setUnitCost (java.lang.Double unitCost) {
			this.unitCost = unitCost;
	}



	/**
	 * Return the value associated with the column: TOTAL_COST
	 */

	public java.lang.Double getTotalCost () {
						return totalCost == null ? Double.valueOf(0) : totalCost;
		}



	/**
	 * Set the value related to the column: TOTAL_COST
	 * @param totalCost the TOTAL_COST value
	 */
			public void setTotalCost (java.lang.Double totalCost) {
			this.totalCost = totalCost;
	}



	/**
	 * Return the value associated with the column: MODIFIER_TYPE
	 */

	public java.lang.Integer getModifierType () {
						return modifierType == null ? Integer.valueOf(0) : modifierType;
		}



	/**
	 * Set the value related to the column: MODIFIER_TYPE
	 * @param modifierType the MODIFIER_TYPE value
	 */
			public void setModifierType (java.lang.Integer modifierType) {
			this.modifierType = modifierType;
	}



	/**
	 * Return the value associated with the column: SUBTOTAL_PRICE
	 */

	public java.lang.Double getSubTotalAmount () {
						return subTotalAmount == null ? Double.valueOf(0) : subTotalAmount;
		}



	/**
	 * Set the value related to the column: SUBTOTAL_PRICE
	 * @param subTotalAmount the SUBTOTAL_PRICE value
	 */
			public void setSubTotalAmount (java.lang.Double subTotalAmount) {
			this.subTotalAmount = subTotalAmount;
	}



	/**
	 * Return the value associated with the column: DISCOUNT_AMOUNT
	 */

	public java.lang.Double getDiscountAmount () {
						return discountAmount == null ? Double.valueOf(0) : discountAmount;
		}



	/**
	 * Set the value related to the column: DISCOUNT_AMOUNT
	 * @param discountAmount the DISCOUNT_AMOUNT value
	 */
			public void setDiscountAmount (java.lang.Double discountAmount) {
			this.discountAmount = discountAmount;
	}



	/**
	 * Return the value associated with the column: TAX_AMOUNT
	 */

	public java.lang.Double getTaxAmount () {
						return taxAmount == null ? Double.valueOf(0) : taxAmount;
		}



	/**
	 * Set the value related to the column: TAX_AMOUNT
	 * @param taxAmount the TAX_AMOUNT value
	 */
			public void setTaxAmount (java.lang.Double taxAmount) {
			this.taxAmount = taxAmount;
	}



	/**
	 * Return the value associated with the column: TAX_EXEMPT_AMOUNT
	 */

	public java.lang.Double getTaxExemptAmount () {
						return taxExemptAmount == null ? Double.valueOf(0) : taxExemptAmount;
		}



	/**
	 * Set the value related to the column: TAX_EXEMPT_AMOUNT
	 * @param taxExemptAmount the TAX_EXEMPT_AMOUNT value
	 */
			public void setTaxExemptAmount (java.lang.Double taxExemptAmount) {
			this.taxExemptAmount = taxExemptAmount;
	}



	/**
	 * Return the value associated with the column: SERVICE_CHARGE
	 */

	public java.lang.Double getServiceCharge () {
						return serviceCharge == null ? Double.valueOf(0) : serviceCharge;
		}



	/**
	 * Set the value related to the column: SERVICE_CHARGE
	 * @param serviceCharge the SERVICE_CHARGE value
	 */
			public void setServiceCharge (java.lang.Double serviceCharge) {
			this.serviceCharge = serviceCharge;
	}



	/**
	 * Return the value associated with the column: TOTAL_PRICE
	 */

	public java.lang.Double getTotalAmount () {
						return totalAmount == null ? Double.valueOf(0) : totalAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_PRICE
	 * @param totalAmount the TOTAL_PRICE value
	 */
			public void setTotalAmount (java.lang.Double totalAmount) {
			this.totalAmount = totalAmount;
	}



	/**
	 * Return the value associated with the column: TAX_INCLUDED
	 */

	public java.lang.Boolean isTaxIncluded () {
					return taxIncluded == null ? Boolean.FALSE : taxIncluded;
		}

	public java.lang.Boolean getTaxIncluded () {
				return taxIncluded == null ? Boolean.FALSE : taxIncluded;
			}


	/**
	 * Set the value related to the column: TAX_INCLUDED
	 * @param taxIncluded the TAX_INCLUDED value
	 */
			public void setTaxIncluded (java.lang.Boolean taxIncluded) {
			this.taxIncluded = taxIncluded;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_UNIT_PRICE
	 */

	public java.lang.Double getAdjustedUnitPrice () {
						return adjustedUnitPrice == null ? Double.valueOf(0) : adjustedUnitPrice;
		}



	/**
	 * Set the value related to the column: ADJUSTED_UNIT_PRICE
	 * @param adjustedUnitPrice the ADJUSTED_UNIT_PRICE value
	 */
			public void setAdjustedUnitPrice (java.lang.Double adjustedUnitPrice) {
			this.adjustedUnitPrice = adjustedUnitPrice;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_DISCOUNT
	 */

	public java.lang.Double getAdjustedDiscount () {
						return adjustedDiscount == null ? Double.valueOf(0) : adjustedDiscount;
		}



	/**
	 * Set the value related to the column: ADJUSTED_DISCOUNT
	 * @param adjustedDiscount the ADJUSTED_DISCOUNT value
	 */
			public void setAdjustedDiscount (java.lang.Double adjustedDiscount) {
			this.adjustedDiscount = adjustedDiscount;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_SUBTOTAL
	 */

	public java.lang.Double getAdjustedSubtotal () {
						return adjustedSubtotal == null ? Double.valueOf(0) : adjustedSubtotal;
		}



	/**
	 * Set the value related to the column: ADJUSTED_SUBTOTAL
	 * @param adjustedSubtotal the ADJUSTED_SUBTOTAL value
	 */
			public void setAdjustedSubtotal (java.lang.Double adjustedSubtotal) {
			this.adjustedSubtotal = adjustedSubtotal;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_TAX
	 */

	public java.lang.Double getAdjustedTax () {
						return adjustedTax == null ? Double.valueOf(0) : adjustedTax;
		}



	/**
	 * Set the value related to the column: ADJUSTED_TAX
	 * @param adjustedTax the ADJUSTED_TAX value
	 */
			public void setAdjustedTax (java.lang.Double adjustedTax) {
			this.adjustedTax = adjustedTax;
	}



	/**
	 * Return the value associated with the column: ADJUSTED_TOTAL
	 */

	public java.lang.Double getAdjustedTotal () {
						return adjustedTotal == null ? Double.valueOf(0) : adjustedTotal;
		}



	/**
	 * Set the value related to the column: ADJUSTED_TOTAL
	 * @param adjustedTotal the ADJUSTED_TOTAL value
	 */
			public void setAdjustedTotal (java.lang.Double adjustedTotal) {
			this.adjustedTotal = adjustedTotal;
	}



	/**
	 * Return the value associated with the column: INFO_ONLY
	 */

	public java.lang.Boolean isInfoOnly () {
					return infoOnly == null ? Boolean.FALSE : infoOnly;
		}

	public java.lang.Boolean getInfoOnly () {
				return infoOnly == null ? Boolean.FALSE : infoOnly;
			}


	/**
	 * Set the value related to the column: INFO_ONLY
	 * @param infoOnly the INFO_ONLY value
	 */
			public void setInfoOnly (java.lang.Boolean infoOnly) {
			this.infoOnly = infoOnly;
	}



	/**
	 * Return the value associated with the column: IS_DEFAULT
	 */

	public java.lang.Boolean isIsDefault () {
					return isDefault == null ? Boolean.FALSE : isDefault;
		}

	public java.lang.Boolean getIsDefault () {
				return isDefault == null ? Boolean.FALSE : isDefault;
			}


	/**
	 * Set the value related to the column: IS_DEFAULT
	 * @param isDefault the IS_DEFAULT value
	 */
			public void setIsDefault (java.lang.Boolean isDefault) {
			this.isDefault = isDefault;
	}



	/**
	 * Return the value associated with the column: SECTION_NAME
	 */

	public java.lang.String getSectionName () {
			return sectionName;
	}



	/**
	 * Set the value related to the column: SECTION_NAME
	 * @param sectionName the SECTION_NAME value
	 */
			public void setSectionName (java.lang.String sectionName) {
			this.sectionName = sectionName;
	}



	/**
	 * Return the value associated with the column: MULTIPLIER_NAME
	 */

	public java.lang.String getMultiplierName () {
			return multiplierName;
	}



	/**
	 * Set the value related to the column: MULTIPLIER_NAME
	 * @param multiplierName the MULTIPLIER_NAME value
	 */
			public void setMultiplierName (java.lang.String multiplierName) {
			this.multiplierName = multiplierName;
	}



	/**
	 * Return the value associated with the column: PRINT_TO_KITCHEN
	 */

	public java.lang.Boolean isShouldPrintToKitchen () {
						return shouldPrintToKitchen == null ? Boolean.valueOf(true) : shouldPrintToKitchen;
			}

	public java.lang.Boolean getShouldPrintToKitchen () {
					return shouldPrintToKitchen == null ? Boolean.valueOf(true) : shouldPrintToKitchen;
			}


	/**
	 * Set the value related to the column: PRINT_TO_KITCHEN
	 * @param shouldPrintToKitchen the PRINT_TO_KITCHEN value
	 */
			public void setShouldPrintToKitchen (java.lang.Boolean shouldPrintToKitchen) {
			this.shouldPrintToKitchen = shouldPrintToKitchen;
	}


	/**
	 * Custom property
	 */
	public static String getShouldPrintToKitchenDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: SECTION_WISE_PRICING
	 */

	public java.lang.Boolean isShouldSectionWisePrice () {
					return shouldSectionWisePrice == null ? Boolean.FALSE : shouldSectionWisePrice;
		}

	public java.lang.Boolean getShouldSectionWisePrice () {
				return shouldSectionWisePrice == null ? Boolean.FALSE : shouldSectionWisePrice;
			}


	/**
	 * Set the value related to the column: SECTION_WISE_PRICING
	 * @param shouldSectionWisePrice the SECTION_WISE_PRICING value
	 */
			public void setShouldSectionWisePrice (java.lang.Boolean shouldSectionWisePrice) {
			this.shouldSectionWisePrice = shouldSectionWisePrice;
	}



	/**
	 * Return the value associated with the column: FRACTIONAL_UNIT
	 */

	public java.lang.Boolean isFractionalUnit () {
					return fractionalUnit == null ? Boolean.FALSE : fractionalUnit;
		}

	public java.lang.Boolean getFractionalUnit () {
				return fractionalUnit == null ? Boolean.FALSE : fractionalUnit;
			}


	/**
	 * Set the value related to the column: FRACTIONAL_UNIT
	 * @param fractionalUnit the FRACTIONAL_UNIT value
	 */
			public void setFractionalUnit (java.lang.Boolean fractionalUnit) {
			this.fractionalUnit = fractionalUnit;
	}



	/**
	 * Return the value associated with the column: PRINTED_TO_KITCHEN
	 */

	public java.lang.Boolean isPrintedToKitchen () {
					return printedToKitchen == null ? Boolean.FALSE : printedToKitchen;
		}

	public java.lang.Boolean getPrintedToKitchen () {
				return printedToKitchen == null ? Boolean.FALSE : printedToKitchen;
			}


	/**
	 * Set the value related to the column: PRINTED_TO_KITCHEN
	 * @param printedToKitchen the PRINTED_TO_KITCHEN value
	 */
			public void setPrintedToKitchen (java.lang.Boolean printedToKitchen) {
			this.printedToKitchen = printedToKitchen;
	}



	/**
	 * Return the value associated with the column: IS_DEFAULT_MODIFIER
	 */

	public java.lang.Boolean isIsDefaultModifier () {
					return isDefaultModifier == null ? Boolean.FALSE : isDefaultModifier;
		}

	public java.lang.Boolean getIsDefaultModifier () {
				return isDefaultModifier == null ? Boolean.FALSE : isDefaultModifier;
			}


	/**
	 * Set the value related to the column: IS_DEFAULT_MODIFIER
	 * @param isDefaultModifier the IS_DEFAULT_MODIFIER value
	 */
			public void setIsDefaultModifier (java.lang.Boolean isDefaultModifier) {
			this.isDefaultModifier = isDefaultModifier;
	}



	/**
	 * Return the value associated with the column: TAXES_PROPERTY
	 */

	public java.lang.String getTaxesProperty () {
			return taxesProperty;
	}



	/**
	 * Set the value related to the column: TAXES_PROPERTY
	 * @param taxesProperty the TAXES_PROPERTY value
	 */
			public void setTaxesProperty (java.lang.String taxesProperty) {
			this.taxesProperty = taxesProperty;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: TICKET_ITEM_ID
	 */

	public com.floreantpos.model.TicketItem getTicketItem () {
			return ticketItem;
	}



	/**
	 * Set the value related to the column: TICKET_ITEM_ID
	 * @param ticketItem the TICKET_ITEM_ID value
	 */
			public void setTicketItem (com.floreantpos.model.TicketItem ticketItem) {
			this.ticketItem = ticketItem;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.TicketItemModifier)) return false;
		else {
			com.floreantpos.model.TicketItemModifier ticketItemModifier = (com.floreantpos.model.TicketItemModifier) obj;
			if (null == this.getId() || null == ticketItemModifier.getId()) return this == obj;
			else return (this.getId().equals(ticketItemModifier.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}