package com.floreantpos.model.dao;

import java.io.Serializable;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.GlobalConfig;

public class GlobalConfigDAO extends BaseGlobalConfigDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public GlobalConfigDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public void addProperty(String key, String value) {
		GlobalConfig globalConfig = findByKey(key);
		if (globalConfig == null) {
			globalConfig = new GlobalConfig();
			globalConfig.setKey(key);
		}
		globalConfig.setValue(value);
		saveOrUpdate(globalConfig);
	}

	public String getProperty(String key) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.setProjection(Projections.property(GlobalConfig.PROP_VALUE));
			criteria.add(Restrictions.eq(GlobalConfig.PROP_KEY, key));
			return (String) criteria.uniqueResult();
		}
	}

	public GlobalConfig findByKey(String key) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(GlobalConfig.PROP_KEY, key));
			criteria.setMaxResults(1);
			return (GlobalConfig) criteria.uniqueResult();
		}
	}
}