package com.floreantpos.model.dao;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.TestItem;
import com.floreantpos.model.TestItemGroup;
import com.floreantpos.swing.PaginationSupport;

public class TestItemDAO extends BaseTestItemDAO {

	public TestItemDAO() {
	}

	public void findByName(PaginationSupport tableModel, String searchString) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(TestItem.class);

			addDeletedFilter(criteria);
			criteria.add(Restrictions.ilike(TestItem.PROP_NAME, searchString, MatchMode.ANYWHERE));

			tableModel.setNumRows(rowCount(criteria));

			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			criteria.addOrder(Order.asc(TestItem.PROP_NAME).ignoreCase());
			criteria.addOrder(Order.asc(TestItem.PROP_SORT_ORDER));
			tableModel.setRows(criteria.list());
		}
	}

	public List<TestItem> findByGroupId(String groupId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(TestItem.class);

			addDeletedFilter(criteria);
			if (StringUtils.isNotBlank(groupId)) {
				criteria.add(Restrictions.eq(TestItem.PROP_TEST_ITEM_GROUP_ID, groupId));
			}
			else {
				criteria.add(Restrictions.eqOrIsNull(TestItem.PROP_TEST_ITEM_GROUP_ID, groupId));
			}
			return criteria.list();
		}

	}

	public TestItem findByName(String testUnitName) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(TestItem.class);

			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(TestItem.PROP_NAME, testUnitName).ignoreCase());
			criteria.setMaxResults(1);
			return (TestItem) criteria.uniqueResult();
		}
	}

}