package com.floreantpos.model.util;

import org.apache.commons.lang.StringUtils;

public enum ReferralCommissionType {
	//@formatter:off
		EMPTY(""), //$NON-NLS-1$
		STANDARD("Standard"),
		PERCENTAGE("Percentage"),
		FIXEDAMOUNT("Fixed amount"),
		GREATER_THAN_SALES_PRICE("Mark up on base price $basePrice") 
		;
		//@formatter:on

	String displayString;

	private ReferralCommissionType(String display) {
		this.displayString = display;
	}

	@Override
	public String toString() {
		return displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public static ReferralCommissionType fromName(String name) {
		if (StringUtils.isEmpty(name)) {
			return ReferralCommissionType.PERCENTAGE;
		}

		ReferralCommissionType[] values = values();
		for (ReferralCommissionType chargeType : values) {
			if (name.equals(chargeType.name())) {
				return chargeType;
			}
		}

		return ReferralCommissionType.PERCENTAGE;
	}
}
