package com.floreantpos.report.model;

import com.floreantpos.report.ReferralCommissionReportData;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class ReferralCommissionReportModel extends ListTableModel {
	public ReferralCommissionReportModel() {
		super(new String[] { "referralType", "referralBy", "orderId", "orderDate", "receivable", "due", "received", "reportDoctor", "agentFee", "labDoctorFee",
				"RFOnReport", "ofcNet", "RFOnNetSales", "RFpayable", "RFpaid", "ofcTotal" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		ReferralCommissionReportData reportData = (ReferralCommissionReportData) rows.get(rowIndex);

		double officeNet = reportData.getReceived() - (reportData.getLabDoctorFee() + reportData.getAgentCommissionOnReport());
		double officeTotal = officeNet - reportData.getAgentCommissionOnNetSales();

		switch (columnIndex) {
			case 0:
				return reportData.getReferralType();

			case 1:
				return reportData.getReferralBy();

			case 2:
				return reportData.getOrderId();

			case 3:
				return reportData.getOrderDate();

			case 4:
				return reportData.getReceivable();

			case 5:
				return reportData.getDue();

			case 6:
				return reportData.getReceived();

			case 7:
				return reportData.getReportDoctor();

			case 8:
				return reportData.getAgentCommissionTotal();

			case 9:
				return reportData.getLabDoctorFee();

			case 10:
				return NumberUtil.formatNumber(reportData.getAgentCommissionOnReport());

			case 11:
				return NumberUtil.formatNumber(officeNet);

			case 12:
				return NumberUtil.formatNumber(reportData.getAgentCommissionOnNetSales());

			case 13:
				return NumberUtil.formatNumber(reportData.getReferrerFeeDueAmount());

			case 14:
				return reportData.getReferrerFeePaidAmount();

			case 15:
				return NumberUtil.formatNumber(officeTotal);

		}
		return null;
	}

}