package com.floreantpos.model.dao;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;

public class PurchaseOrderItemDAO extends BasePurchaseOrderItemDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public PurchaseOrderItemDAO() {
	}

	public List<MenuItem> getMenuItems(InventoryVendor vendor) {
		Session session = null;
		Criteria criteria = null;
		try {
			List<MenuItem> menuItems = new ArrayList<>();
			session = getSession();
			criteria = session.createCriteria(PurchaseOrderItem.class);
			criteria.setProjection(Projections.distinct(Projections.property(PurchaseOrderItem.PROP_MENU_ITEM_ID)));
			criteria.createAlias(PurchaseOrderItem.PROP_PURCHASE_ORDER, "p"); //$NON-NLS-1$
			criteria.add(Restrictions.eq("p.vendor", vendor)); //$NON-NLS-1$

			List<Integer> list = criteria.list();

			if (list != null) {
				for (Integer item : list) {
					MenuItem menuItem = MenuItemDAO.getInstance().getReplenishedMenuItem(item, session);
					if (menuItem != null) {
						menuItems.add(menuItem);
					}
				}
			}
			return menuItems;
		} finally {
			closeSession(session);
		}
	}

	public void loadCustomers(PurchaseOrderItem purchaseOrderItem) {
		if (purchaseOrderItem == null || purchaseOrderItem.getId() == null)
			return;
		if (Hibernate.isInitialized(purchaseOrderItem.getCustomers())) {
			return;
		}
		Session session = createNewSession();
		try {
			session.refresh(purchaseOrderItem);
			Hibernate.initialize(purchaseOrderItem.getCustomers());
		} finally {
			closeSession(session);
		}
	}

	public void initializeCustomers(PurchaseOrderItem purchaseOrderItem) {
		Session session = null;
		try {
			session = createNewSession();
			session.refresh(purchaseOrderItem);
			if (!Hibernate.isInitialized(purchaseOrderItem.getCustomers())) {
				Hibernate.initialize(purchaseOrderItem.getCustomers());
			}
		} finally {
			if (session != null) {
				session.close();
			}
		}
	}

	public PurchaseOrderItem findCostByVendor(InventoryVendor vendor) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(PurchaseOrderItem.class);
			criteria.createAlias(PurchaseOrderItem.PROP_PURCHASE_ORDER, "p"); //$NON-NLS-1$
			criteria.add(Restrictions.eq("p." + PurchaseOrder.PROP_VENDOR, vendor)); //$NON-NLS-1$
			criteria.add(Restrictions.eq("p." + PurchaseOrder.PROP_STATUS, PurchaseOrder.ORDER_FULLY_RECEIVED)); //$NON-NLS-1$
			criteria.addOrder(Order.desc("p." + PurchaseOrder.PROP_CREATED_DATE)); //$NON-NLS-1$
			criteria.setMaxResults(1);
			return (PurchaseOrderItem) criteria.uniqueResult();
		}
	}

}