package com.floreantpos.report.model;

import com.floreantpos.model.Department;
import com.floreantpos.model.Doctor;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.dao.DoctorDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ListTableModel;

public class LabDoctorPaymentsReportModel extends ListTableModel {
	public LabDoctorPaymentsReportModel() {
		super(new String[] { "customerName", "date", "paymentType", "amount", "department" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		PosTransaction reportData = (PosTransaction) rows.get(rowIndex);
		switch (columnIndex) {
			case 0:
				return reportData.getCustomerName();

			case 1:
				return reportData.getDateDisplayString();

			case 2:

				return reportData.getPaymentTypeDisplayString();

			case 3:
				Double amount = reportData.getAmount();
				if (amount.isNaN()) {
					return 0d;
				}
				return amount;

			case 4:

				String accountNumber = reportData.getCustomerId();
				Doctor doctor = DoctorDAO.getInstance().get(accountNumber);
				if (doctor == null) {
					return "";
				}
				String departmentId = doctor.getDoctorDepartmentId();
				if (departmentId != null) {
					Department department = DataProvider.get().getDepartmentById(departmentId);
					if (department == null) {
						return "";
					}
					return department.getName();
				}

		}
		return null;
	}

}