package com.floreantpos.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreantpos.PosLog;
import com.floreantpos.model.base.BaseModifierGroup;
import com.floreantpos.ui.model.ModifierPricingRule;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "displayName" })
@XmlRootElement
public class ModifierGroup extends BaseModifierGroup implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	private transient JsonObject propertiesContainer;
	public static final String JSON_PROP_ENABLE_GROUP_PRICE = "enableGroupPricing"; //$NON-NLS-1$

	private Map<Integer, Double> priceMap;
	private ArrayList<ModifierPricingRule> pricingRules;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public ModifierGroup() {
	}

	public ModifierGroup(java.lang.String id) {
		super(id);
	}

	@Override
	public String toString() {
		return super.getName();
	}

	public String getDisplayName() {
		String translated = super.getTranslatedName();
		return translated != null && StringUtils.isNotBlank(translated) ? translated: super.getName();
	}

	public String getUniqueId() {
		return ("modifiergroup_" + getName() + "_" + getId()).replaceAll("\\s+", "_"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	public void setEnableGroupPricing(boolean isEnableGroupWisePricing) {
		addProperty(MenuItemModifierSpec.JSON_PROP_ENABLE_GROUP_PRICE, String.valueOf(isEnableGroupWisePricing));
	}

	public boolean isEnableGroupPricing() {
		return hasProperty(JSON_PROP_ENABLE_GROUP_PRICE) && getBooleanProperty(JSON_PROP_ENABLE_GROUP_PRICE, false);
	}

	public boolean hasPriceRules() {
		return isEnableGroupPricing() && hasProperty(MenuItemModifierSpec.JSON_PROP_PRICE_RULES);
	}

	public Double getPrice(Integer quantity) {
		if (!hasPriceRules()) {
			return null;
		}
		if (priceMap != null) {
			return priceMap.get(quantity);
		}
		priceMap = new HashMap<Integer, Double>();
		List<ModifierPricingRule> priceList = getPriceRules();
		if (priceList != null && priceList.size() > 0) {
			for (ModifierPricingRule pricing : priceList) {
				for (int i = pricing.getFromQty(); i <= pricing.getToQty(); i++) {
					priceMap.put(i, pricing.getPrice());
				}
			}
		}
		return priceMap.get(quantity);
	}

	public List getPriceRules() {
		try {
			if (pricingRules == null) {
				pricingRules = new ArrayList<ModifierPricingRule>();
			}

			String properties = getProperties();
			if (StringUtils.isEmpty(properties)) {
				return pricingRules;
			}
			ObjectMapper mapper = new ObjectMapper();
			JsonNode readTree = mapper.readTree(properties);
			if (readTree != null) {
				JsonNode arrayNode = readTree.findValue(MenuItemModifierSpec.JSON_PROP_PRICE_RULES);
				if (arrayNode != null) {
					pricingRules = mapper.readValue(arrayNode.toString(), new TypeReference<List<ModifierPricingRule>>() {
					});
					return pricingRules;
				}
			}
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
		return pricingRules;
	}

	@XmlTransient
	@JsonIgnore
	public List<MenuItemModifierPageItem> getMenuItemModifierPageItems() {
		Set<MenuItemModifierPage> modifierPages = this.getModifierPages();
		if (modifierPages == null) {
			return new ArrayList<>(0);
		}
		List<MenuItemModifierPageItem> menuItemModifierPageItems = new ArrayList<>();
		for (MenuItemModifierPage page : modifierPages) {
			List<MenuItemModifierPageItem> items = page.getPageItems();
			if (items != null) {
				menuItemModifierPageItems.addAll(items);
			}
			//			if (items != null) {
			//				Collections.sort(items, (item1, item2) -> item1.getCol().compareTo(item2.getCol()));
			//				Collections.sort(items, (item1, item2) -> item1.getRow().compareTo(item2.getRow()));
			//				for (MenuItemModifierPageItem pageItem : items) {
			//					menuItemModifierPageItems.add(pageItem);
			//				}
			//			}
		}
		return menuItemModifierPageItems;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			if (StringUtils.isBlank(super.getProperties())) {
				propertiesContainer = new com.google.gson.JsonObject();
			}
			else {
				propertiesContainer = new Gson().fromJson(super.getProperties(), JsonObject.class);
			}
		}
		return propertiesContainer;
	}

	public void setInstruction(String instruction) {
		addProperty("instruction", instruction); //$NON-NLS-1$
	}

	@JsonIgnore
	public String getInstruction() {
		return getProperty("instruction"); //$NON-NLS-1$
	}

	@XmlTransient
	@JsonIgnore
	public Set<MenuModifier> getModifiersWithPageItemId() {
		Set<MenuItemModifierPage> modifierPages = getModifierPages();
		Set<MenuModifier> menuModifiers = new HashSet<>();
		if (modifierPages != null) {
			for (MenuItemModifierPage page : modifierPages) {
				if (page.getPageItems() != null) {
					for (MenuItemModifierPageItem pageItem : page.getPageItems()) {
						MenuModifier modifier = pageItem.getMenuModifier();
						if (modifier != null) {
							modifier.setPageItemId(pageItem.getId());
							menuModifiers.add(modifier);
						}
					}
				}
			}
		}
		return menuModifiers;
	}
}