package com.floreantpos.model;

import java.util.ArrayList;
import java.util.List;

import com.floreantpos.model.base.BaseTestItemGroup;

public class TestItemGroup extends BaseTestItemGroup {
	private static final long serialVersionUID = 1L;

	private transient List<TestItem> testItems;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public TestItemGroup() {
	}

	/**
	 * Constructor for primary key
	 */
	public TestItemGroup(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public TestItemGroup(java.lang.String id, java.lang.String name) {

		super(id, name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		return getName();
	}

	public List<TestItem> getTestItems() {
		return testItems;
	}

	public void addToTestItem(TestItem testItem) {
		if (testItems == null) {
			testItems = new ArrayList<TestItem>();
		}
		testItems.add(testItem);
	}

}