package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseStockCountItem;
import com.floreantpos.model.dao.MenuItemDAO;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "menuItem", "stockCount" })
public class StockCountItem extends BaseStockCountItem {
	private static final long serialVersionUID = 1L;

	public StockCountItem() {
	}

	public StockCountItem(java.lang.String id) {
		super(id);
	}

	public StockCountItem(java.lang.String id, com.floreantpos.model.StockCount stockCount) {

		super(id, stockCount);
	}

	private MenuItem menuItem;

	@XmlTransient
	public MenuItem getMenuItem() {
		if (menuItem == null) {
			String itemId = getItemId();
			if (StringUtils.isEmpty(itemId)) {
				return null;
			}
			menuItem = MenuItemDAO.getInstance().loadInitialized(itemId);
		}

		return menuItem;
	}

	public void setMenuItem(MenuItem menuItem) {
		this.menuItem = menuItem;
	}

	public double getCountVariance() {
		return getActualUnit() - getUnitOnHand();
	}

	public void setCountVariance(double countVariance) {
	}

	public double getCostVariance() {
		return getCountVariance() * getCost();
	}

	public void setCostVariance(double costVariance) {
	}

}