package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the INVENTORY_LOCATION table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="INVENTORY_LOCATION"
 */

public abstract class BaseInventoryLocation  implements Comparable, Serializable {

	public static String REF = "InventoryLocation"; //$NON-NLS-1$
	public static String PROP_DEFAULT_IN_LOCATION = "defaultInLocation"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_ADDRESS = "address"; //$NON-NLS-1$
	public static String PROP_ROOT = "root"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_CODE = "code"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_TRANSLATED_NAME = "translatedName"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_VISIBLE = "visible"; //$NON-NLS-1$
	public static String PROP_PARENT_LOCATION = "parentLocation"; //$NON-NLS-1$
	public static String PROP_DEFAULT_OUT_LOCATION = "defaultOutLocation"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$


	// constructors
	public BaseInventoryLocation () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseInventoryLocation (
		java.lang.String id,
		java.lang.String outletId) {

		this.setId(id);
		this.setOutletId(outletId);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseInventoryLocation (
		java.lang.String id,
		java.lang.String outletId,
		java.lang.String name) {

		this.setId(id);
		this.setOutletId(outletId);
		this.setName(name);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key

	private java.lang.String id;

	private java.lang.String outletId;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.String translatedName;
				private java.lang.String address;
				private java.lang.Integer sortOrder;
				private java.lang.Boolean visible;
				private java.lang.Boolean root;
				private java.lang.Boolean defaultInLocation;
				private java.lang.Boolean defaultOutLocation;
				private java.lang.String code;
				private java.lang.String description;
				private java.lang.Boolean deleted;
	
	// many to one
	private com.floreantpos.model.InventoryLocation parentLocation;

	// collections
	private java.util.List<com.floreantpos.model.InventoryLocation> children;



	/**
     * @hibernate.property
     *  column=ID
	 * not-null=true
	 */
	public java.lang.String getId () {
		return this.id;
	}

	/**
	 * Set the value related to the column: ID
	 * @param id the ID value
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
     * @hibernate.property
     *  column=OUTLET_ID
	 * not-null=true
	 */
	public java.lang.String getOutletId () {
		return this.outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: TRANSLATED_NAME
	 */

	public java.lang.String getTranslatedName () {
			return translatedName;
	}



	/**
	 * Set the value related to the column: TRANSLATED_NAME
	 * @param translatedName the TRANSLATED_NAME value
	 */
			public void setTranslatedName (java.lang.String translatedName) {
			this.translatedName = translatedName;
	}



	/**
	 * Return the value associated with the column: ADDRESS
	 */

	public java.lang.String getAddress () {
			return address;
	}



	/**
	 * Set the value related to the column: ADDRESS
	 * @param address the ADDRESS value
	 */
			public void setAddress (java.lang.String address) {
			this.address = address;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: VISIBLE
	 */

	public java.lang.Boolean isVisible () {
					return visible == null ? Boolean.FALSE : visible;
		}

	public java.lang.Boolean getVisible () {
				return visible == null ? Boolean.FALSE : visible;
			}


	/**
	 * Set the value related to the column: VISIBLE
	 * @param visible the VISIBLE value
	 */
			public void setVisible (java.lang.Boolean visible) {
			this.visible = visible;
	}



	/**
	 * Return the value associated with the column: ROOT
	 */

	public java.lang.Boolean isRoot () {
					return root == null ? Boolean.FALSE : root;
		}

	public java.lang.Boolean getRoot () {
				return root == null ? Boolean.FALSE : root;
			}


	/**
	 * Set the value related to the column: ROOT
	 * @param root the ROOT value
	 */
			public void setRoot (java.lang.Boolean root) {
			this.root = root;
	}



	/**
	 * Return the value associated with the column: DEFAULT_IN_LOCATION
	 */

	public java.lang.Boolean isDefaultInLocation () {
					return defaultInLocation == null ? Boolean.FALSE : defaultInLocation;
		}

	public java.lang.Boolean getDefaultInLocation () {
				return defaultInLocation == null ? Boolean.FALSE : defaultInLocation;
			}


	/**
	 * Set the value related to the column: DEFAULT_IN_LOCATION
	 * @param defaultInLocation the DEFAULT_IN_LOCATION value
	 */
			public void setDefaultInLocation (java.lang.Boolean defaultInLocation) {
			this.defaultInLocation = defaultInLocation;
	}



	/**
	 * Return the value associated with the column: DEFAULT_OUT_LOCATION
	 */

	public java.lang.Boolean isDefaultOutLocation () {
					return defaultOutLocation == null ? Boolean.FALSE : defaultOutLocation;
		}

	public java.lang.Boolean getDefaultOutLocation () {
				return defaultOutLocation == null ? Boolean.FALSE : defaultOutLocation;
			}


	/**
	 * Set the value related to the column: DEFAULT_OUT_LOCATION
	 * @param defaultOutLocation the DEFAULT_OUT_LOCATION value
	 */
			public void setDefaultOutLocation (java.lang.Boolean defaultOutLocation) {
			this.defaultOutLocation = defaultOutLocation;
	}



	/**
	 * Return the value associated with the column: CODE
	 */

	public java.lang.String getCode () {
			return code;
	}



	/**
	 * Set the value related to the column: CODE
	 * @param code the CODE value
	 */
			public void setCode (java.lang.String code) {
			this.code = code;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: PARENT_ID
	 */

	public com.floreantpos.model.InventoryLocation getParentLocation () {
			return parentLocation;
	}



	/**
	 * Set the value related to the column: PARENT_ID
	 * @param parentLocation the PARENT_ID value
	 */
			public void setParentLocation (com.floreantpos.model.InventoryLocation parentLocation) {
			this.parentLocation = parentLocation;
	}



	/**
	 * Return the value associated with the column: children
	 */

	public java.util.List<com.floreantpos.model.InventoryLocation> getChildren () {
			return children;
	}



	/**
	 * Set the value related to the column: children
	 * @param children the children value
	 */
			public void setChildren (java.util.List<com.floreantpos.model.InventoryLocation> children) {
			this.children = children;
	}

	public void addTochildren (com.floreantpos.model.InventoryLocation inventoryLocation) {
		if (null == getChildren()) setChildren(new java.util.ArrayList<com.floreantpos.model.InventoryLocation>());
		getChildren().add(inventoryLocation);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;//abcd
		if (!(obj instanceof com.floreantpos.model.InventoryLocation)) return false;
		else {
			com.floreantpos.model.InventoryLocation inventoryLocation = (com.floreantpos.model.InventoryLocation) obj;
			if (null != this.getId() && null != inventoryLocation.getId()) {
				if (!this.getId().equals(inventoryLocation.getId())) {
					return false;
				}
			}
			else {
				return false;
			}
			if (null != this.getOutletId() && null != inventoryLocation.getOutletId()) {
				if (!this.getOutletId().equals(inventoryLocation.getOutletId())) {
					return false;
				}
			}
			else {
				return false;
			}
			return true;
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			StringBuilder sb = new StringBuilder();
			if (null != this.getId()) {
				sb.append(this.getId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			if (null != this.getOutletId()) {
				sb.append(this.getOutletId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			this.hashCode = sb.toString().hashCode();
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}