/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.util.List;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;
import com.floreantpos.model.LdfPayTransaction;
import com.floreantpos.model.RfPayTransaction;
import com.floreantpos.model.dao.LdfPayTransactionDAO;
import com.floreantpos.model.dao.RfPayTransactionDAO;

public class UpdateDBTo330 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo330(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() {

		PosLog.info(getClass(), "Updating " + schemaName + " schema.");
		try (Session session = sessionFactory.openSession()) {

			Transaction transaction = session.beginTransaction();
			List<LdfPayTransaction> ldfTransactions = LdfPayTransactionDAO.getInstance().findAll();
			PosLog.info(getClass(), "Updating " + ldfTransactions.size() + " Ldf Pay Transaction.");
			if (ldfTransactions != null) {
				for (LdfPayTransaction ldfPayTransaction : ldfTransactions) {
					String receipentId = ldfPayTransaction.getCustomerId();
					ldfPayTransaction.setRecepientId(receipentId);
					ldfPayTransaction.setCustomerId(null);
					session.saveOrUpdate(ldfPayTransaction);
				}
			}

			List<RfPayTransaction> rFTransactions = RfPayTransactionDAO.getInstance().findAll();
			PosLog.info(getClass(), "Updating " + rFTransactions.size() + " RF Pay Transaction.");
			if (rFTransactions != null) {
				for (RfPayTransaction rfPayTransaction : rFTransactions) {
					String receipentId = rfPayTransaction.getCustomerId();
					rfPayTransaction.setRecepientId(receipentId);
					rfPayTransaction.setCustomerId(null);
					session.saveOrUpdate(rfPayTransaction);
				}
			}

			transaction.commit();
		}

	}
}