package com.floreantpos.model.dao;

import java.util.Date;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.LdfPayTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;

public class LdfPayTransactionDAO extends BaseLdfPayTransactionDAO {

	public LdfPayTransactionDAO() {
	}

	public LdfPayTransaction createLdfPayTransaction(String ticketIds, Customer referrer, double payoutAmount, double tenderAmount, CustomPayment customPayment,
			String customPaymnetRef, User currentUser, Terminal drawerTerminal, CashDrawer cashDrawer, Session session) throws Exception {
		if (referrer == null) {
			return null;
		}

		StoreSession storeSession = DataProvider.get().getStoreSession();
		if (storeSession == null && cashDrawer != null) {
			storeSession = cashDrawer.getStoreSession();
		}

		LdfPayTransaction ldfPayTransaction = new LdfPayTransaction();

		if (customPayment != null) {
			ldfPayTransaction.setPaymentType(PaymentType.CUSTOM_PAYMENT);
			ldfPayTransaction.setCustomPaymentId(customPayment.getId());
			ldfPayTransaction.setCustomPaymentRef(customPaymnetRef);
			ldfPayTransaction.setCustomPaymentName(customPayment.getName());
		}
		else {
			ldfPayTransaction.setPaymentType(PaymentType.CASH);
		}
		ldfPayTransaction.setTransactionType(TransactionType.OUT.name());
		ldfPayTransaction.setAmount(Double.valueOf(payoutAmount));
		
		ldfPayTransaction.setTenderAmount(tenderAmount);
		if (tenderAmount > payoutAmount) {
			ldfPayTransaction.setChangeAmount(tenderAmount - payoutAmount);
		}
		ldfPayTransaction.setRecepientId(referrer.getId());
		ldfPayTransaction.setCashDrawer(cashDrawer);
		if (storeSession != null) {
			ldfPayTransaction.setStoreSessionId(storeSession.getId());
		}

		ldfPayTransaction.setTransTicketIds(ticketIds);
		ldfPayTransaction.setOutletId(DataProvider.get().getOutletId());
		ldfPayTransaction.setUser(currentUser);
		ldfPayTransaction.setServer(currentUser);
		ldfPayTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
		ldfPayTransaction.setTerminal(drawerTerminal);

		saveOrUpdate(ldfPayTransaction, session);
		return ldfPayTransaction;
	}

	public List<LdfPayTransaction> findLDFPayments(Date startTime, Date endTime, Customer referrer) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(LdfPayTransaction.class);
			criteria.add(Restrictions.eq(LdfPayTransaction.PROP_VOIDED, false));

			if (referrer != null) {
				criteria.add(Restrictions.eq(LdfPayTransaction.PROP_RECEPIENT_ID, referrer.getId()));
			}
			criteria.add(Restrictions.between(LdfPayTransaction.PROP_TRANSACTION_TIME, DateUtil.startOfDay(startTime), DateUtil.endOfDay(endTime)));
			criteria.addOrder(Order.desc(LdfPayTransaction.PROP_TRANSACTION_TIME));
			return criteria.list();
		}
	}

}