package com.floreantpos.report.model;

import java.util.Date;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.ListTableModel;

public class StaffBankReportModel extends ListTableModel {

	public StaffBankReportModel() {
		super(new String[] { "startTime", "reportTime", "netSales", "cashToDeposit" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		CashDrawer data = (CashDrawer) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				Date startTime = data.getStartTime();
				if (startTime != null)
					return ReportService.formatFullDate(startTime);
				return null;
			case 1:
				Date reportTime = data.getReportTime();
				if (reportTime != null)
					return ReportService.formatFullDate(reportTime);
				return null;
			case 2:
				return data.getGrossReceipts();

			case 3:
				return data.getCashToDeposit();
		}
		return null;
	}

}
