package com.floreantpos.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class GsonUtil {

	public static Gson createGson() {
		//@formatter:off
		ExclusionStrategy strategy = new ExclusionStrategy() {
			@Override
			public boolean shouldSkipField(FieldAttributes f) {
				if (f.getName().equals("hashCode")) { //$NON-NLS-1$
					return true;
				}
				return false;
			}

			@Override
			public boolean shouldSkipClass(Class<?> clazz) {
				return false;
			}
			
			
		};
		
		Gson gson = new GsonBuilder()
				.addSerializationExclusionStrategy(strategy)
				.setDateFormat("E MMM dd HH:mm:ss Z yyyy") //$NON-NLS-1$
				.create();
		//@formatter:on
		return gson;
	}
}
