package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum ReportType {

	//@formatter:off
	TABULAR_REPORT("Tabular report"), 
	PLAIN_REPORT("Plain report"), 
	;
	//@formatter:on

	private final String reportType;

	public String getReportType() {
		return reportType;
	}

	private ReportType(String reportTyp) {
		this.reportType = reportTyp;
	}

	public static ReportType fromString(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}

		ReportType[] values = values();
		for (ReportType reportTypeEnum : values) {
			if (name.equals(reportTypeEnum.name())) {
				return reportTypeEnum;
			}
		}

		return null;
	}

	@Override
	public String toString() {
		return reportType;
	}

}
