package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the COMBO_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="COMBO_ITEM"
 */

public abstract class BaseComboItem  implements Comparable, Serializable {

	public static String REF = "ComboItem"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_PRICE = "price"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_ID = "menuItemId"; //$NON-NLS-1$
	public static String PROP_QUANTITY = "quantity"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_ITEM_ID = "itemId"; //$NON-NLS-1$
	public static String PROP_COST = "cost"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$


	// constructors
	public BaseComboItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseComboItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String itemId;
				private java.lang.String menuItemId;
				private java.lang.String name;
				private java.lang.Double price;
				private java.lang.Double cost;
				private java.lang.Double quantity;
				private java.lang.String outletId;
				private java.lang.Boolean deleted;
				private java.lang.String properties;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: ITEM_ID
	 */

	public java.lang.String getItemId () {
			return itemId;
	}



	/**
	 * Set the value related to the column: ITEM_ID
	 * @param itemId the ITEM_ID value
	 */
			public void setItemId (java.lang.String itemId) {
			this.itemId = itemId;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_ID
	 */

	public java.lang.String getMenuItemId () {
			return menuItemId;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_ID
	 * @param menuItemId the MENU_ITEM_ID value
	 */
			public void setMenuItemId (java.lang.String menuItemId) {
			this.menuItemId = menuItemId;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: PRICE
	 */

	public java.lang.Double getPrice () {
						return price == null ? Double.valueOf(0) : price;
		}



	/**
	 * Set the value related to the column: PRICE
	 * @param price the PRICE value
	 */
			public void setPrice (java.lang.Double price) {
			this.price = price;
	}



	/**
	 * Return the value associated with the column: COST
	 */

	public java.lang.Double getCost () {
						return cost == null ? Double.valueOf(0) : cost;
		}



	/**
	 * Set the value related to the column: COST
	 * @param cost the COST value
	 */
			public void setCost (java.lang.Double cost) {
			this.cost = cost;
	}



	/**
	 * Return the value associated with the column: QUANTITY
	 */

	public java.lang.Double getQuantity () {
						return quantity == null ? Double.valueOf(0) : quantity;
		}



	/**
	 * Set the value related to the column: QUANTITY
	 * @param quantity the QUANTITY value
	 */
			public void setQuantity (java.lang.Double quantity) {
			this.quantity = quantity;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.ComboItem)) return false;
		else {
			com.floreantpos.model.ComboItem comboItem = (com.floreantpos.model.ComboItem) obj;
			if (null == this.getId() || null == comboItem.getId()) return this == obj;
			else return (this.getId().equals(comboItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}