package com.floreantpos.model.dao;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.Specimen;

public class SpecimenDAO extends BaseSpecimenDAO {

	public SpecimenDAO() {
	}

	public Specimen findByName(String specimenName) {
		try (Session session = createNewSession()) {
			return findByName(specimenName, session);
		}
	}

	public Specimen findByName(String specimenName, Session session) {
		Criteria criteria = session.createCriteria(Specimen.class);
		criteria.add(Restrictions.eq(Specimen.PROP_NAME, specimenName));
		return (Specimen) criteria.uniqueResult();
	}
}