/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.TestItem;
import com.floreantpos.model.TestItemGroup;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.TestItemGroupDAO;
import com.floreantpos.swing.ListTableModel;

public class LabTestResultReportModel extends ListTableModel<TestItem> {

	public LabTestResultReportModel() {
		super(new String[] { "itemName", "testResult", "unitName", "referenceValue", "approveResultNote", "testCategoryName" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		TestItem labTestItem = (TestItem) rows.get(rowIndex);
		TicketItem ticketItem = labTestItem.getTicketItem();

		switch (columnIndex) {
			case 0:
				return labTestItem.getName();

			case 1:
				String testResult = labTestItem.getResult();
				return StringUtils.isBlank(testResult) ? "Pending" : testResult + " " + labTestItem.getUnitName();

			case 2:
				return labTestItem.getUnitName();

			case 3:
				return labTestItem.getNormalValue();

			case 4:
				return labTestItem.getApprovedNote();

			case 5:
				String testItemGroupId = labTestItem.getTestItemGroupId();
				if (StringUtils.isNotBlank(testItemGroupId)) {
					TestItemGroup testItemGroup = TestItemGroupDAO.getInstance().get(testItemGroupId);
					return testItemGroup.getName();
				}
				return ""; //$NON-NLS-1$

		}
		return null;
	}

}
