/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.main;

import java.util.Date;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;

public class Application {
	protected Application() {
	}


	public synchronized static Application getInstance() {
		return new Application();
	}

	public Terminal getTerminal() {
		return DataProvider.get().getCurrentTerminal();
	}

	public static String formatDate(Date date) {
		return DateUtil.formatDate(date);
	}

	public Store getStore() {
		return DataProvider.get().getStore();
	}

	public static Outlet getOutlet() {
		return DataProvider.get().getOutlet();
	}

	public Boolean isPriceIncludesTax() {
		return DataProvider.get().getOutlet().isItemPriceIncludesTax();
	}

	public static PosPrinters getPrinters() {
		return null;
	}

}